## setup
```bash
# 1.install

# label node
kubectl label node <nodename> harbor=enabled

helm install \
/etc/kubernetes/helm/harbor \
--name=harbor \
--namespace=devops \
-f /etc/kubernetes/helm/harbor/values-overrides.yaml

# uninstall
helm delete harbor --purge

# update
helm upgrade harbor /etc/kubernetes/helm/harbor \
-f /etc/kubernetes/helm/harbor/values-overrides.yaml
```

## overrides

```bash
cat /etc/kubernetes/helm/harbor/values-overrides.yaml
```

### 有持久化存储Storage

参考values-storage.yaml

### 使用HostPath存储数据

在此之前规划一下哪台服务器存储什么内容

```
harbor: enabled

kubectl label node <nodename> harbor=enabled
# kubectl label node <nodename> harbor-
```

参考values-hostpath.yaml


# images

```bash
# harbor-ui
docker pull goharbor/harbor-ui:v1.6.3 && \
docker tag goharbor/harbor-ui:v1.6.3  registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-ui:v1.6.3  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-ui:v1.6.3 

# harbor-adminserver
docker pull goharbor/harbor-adminserver:v1.6.3 && \
docker tag goharbor/harbor-adminserver:v1.6.3  registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-adminserver:v1.6.3  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-adminserver:v1.6.3 

# harbor-jobservice
docker pull goharbor/harbor-jobservice:v1.6.3 && \
docker tag goharbor/harbor-jobservice:v1.6.3  registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-jobservice:v1.6.3  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-jobservice:v1.6.3 

# harbor-db
docker pull goharbor/harbor-db:v1.6.3 && \
docker tag goharbor/harbor-db:v1.6.3  registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-db:v1.6.3  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-db:v1.6.3 

# chartmuseum
docker pull chartmuseum/chartmuseum:v0.7.1 && \
docker tag chartmuseum/chartmuseum:v0.7.1  registry-vpc.cn-qingdao.aliyuncs.com/wod/chartmuseum:v0.7.1  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/chartmuseum:v0.7.1 

# clair
docker pull quay.io/coreos/clair:v2.0.6 && \
docker tag quay.io/coreos/clair:v2.0.6  registry-vpc.cn-qingdao.aliyuncs.com/wod/clair:v2.0.6  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/clair:v2.0.6

# notary:server
docker pull notary:server-0.5.0 && \
docker tag notary:server-0.5.0  registry-vpc.cn-qingdao.aliyuncs.com/wod/notary-server:0.5.0  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/notary-server:0.5.0

# notary:signer
docker pull notary:signer-0.5.0 && \
docker tag notary:signer-0.5.0  registry-vpc.cn-qingdao.aliyuncs.com/wod/notary-signer:0.5.0  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/notary-signer:0.5.0

# registry
docker pull registry:2.6.2 && \
docker tag registry:2.6.2  registry-vpc.cn-qingdao.aliyuncs.com/wod/registry:2.6.2  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/registry:2.6.2 

# redis
docker pull redis:4.0.1-alpine && \
docker tag redis:4.0.1-alpine  registry-vpc.cn-qingdao.aliyuncs.com/wod/redis:4.0.1-alpine  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/redis:4.0.1-alpine
```