# harbor

## install

```bash
# 1.install
helm install \
--namespace=devops \
harbor \
/etc/kubernetes/helm/harbor \
-f /etc/kubernetes/helm/harbor/values-overrides.yaml

# uninstall
helm uninstall \
--namespace=devops \
harbor

# update
helm upgrade \
--namespace=devops \
harbor \
/etc/kubernetes/helm/harbor \
-f /etc/kubernetes/helm/harbor/values-overrides.yaml

# template
helm template \
--namespace=devops \
harbor \
/etc/kubernetes/helm/harbor \
-f /etc/kubernetes/helm/harbor/values-overrides.yaml > /etc/kubernetes/helm/harbor/dist.yaml
```

## images x86_64

```bash
# goharbor/harbor-portal
docker pull goharbor/harbor-portal:v2.1.1 && \
docker tag goharbor/harbor-portal:v2.1.1 registry.cn-qingdao.aliyuncs.com/wod/harbor-portal:v2.1.1 && \
docker push registry.cn-qingdao.aliyuncs.com/wod/harbor-portal:v2.1.1

# goharbor/harbor-core
docker pull goharbor/harbor-core:v2.1.1 && \
docker tag goharbor/harbor-core:v2.1.1 registry.cn-qingdao.aliyuncs.com/wod/harbor-core:v2.1.1 && \
docker push registry.cn-qingdao.aliyuncs.com/wod/harbor-core:v2.1.1

# goharbor/harbor-jobservice
docker pull goharbor/harbor-jobservice:v2.1.1 && \
docker tag goharbor/harbor-jobservice:v2.1.1 registry.cn-qingdao.aliyuncs.com/wod/harbor-jobservice:v2.1.1 && \
docker push registry.cn-qingdao.aliyuncs.com/wod/harbor-jobservice:v2.1.1

# goharbor/harbor-db
docker pull goharbor/harbor-db:v2.1.1 && \
docker tag goharbor/harbor-db:v2.1.1 registry.cn-qingdao.aliyuncs.com/wod/harbor-db:v2.1.1 && \
docker push registry.cn-qingdao.aliyuncs.com/wod/harbor-db:v2.1.1

# registry
docker pull registry:2.7.1 && \
docker tag registry:2.7.1 registry.cn-qingdao.aliyuncs.com/wod/registry:2.7.1 && \
docker push registry.cn-qingdao.aliyuncs.com/wod/registry:2.7.1

# goharbor/harbor-registryctl
docker pull goharbor/harbor-registryctl:v2.1.1 && \
docker tag goharbor/harbor-registryctl:v2.1.1 registry.cn-qingdao.aliyuncs.com/wod/harbor-registryctl:v2.1.1 && \
docker push registry.cn-qingdao.aliyuncs.com/wod/harbor-registryctl:v2.1.1

# goharbor/chartmuseum-photon
docker pull goharbor/chartmuseum-photon:v2.1.1 && \
docker tag goharbor/chartmuseum-photon:v2.1.1 registry.cn-qingdao.aliyuncs.com/wod/chartmuseum-photon:v2.1.1 && \
docker push registry.cn-qingdao.aliyuncs.com/wod/chartmuseum-photon:v2.1.1

# goharbor/clair-photon
docker pull goharbor/clair-photon:v2.1.1 && \
docker tag goharbor/clair-photon:v2.1.1 registry.cn-qingdao.aliyuncs.com/wod/clair-photon:v2.1.1 && \
docker push registry.cn-qingdao.aliyuncs.com/wod/clair-photon:v2.1.1

docker pull goharbor/clair-adapter-photon:v2.1.1 && \
docker tag goharbor/clair-adapter-photon:v2.1.1 registry.cn-qingdao.aliyuncs.com/wod/clair-adapter-photon:v2.1.1 && \
docker push registry.cn-qingdao.aliyuncs.com/wod/clair-adapter-photon:v2.1.1

# goharbor/trivy
docker pull goharbor/trivy-adapter-photon:v2.1.1 && \
docker tag goharbor/trivy-adapter-photon:v2.1.1 registry.cn-qingdao.aliyuncs.com/wod/trivy-adapter-photon:v2.1.1 && \
docker push registry.cn-qingdao.aliyuncs.com/wod/trivy-adapter-photon:v2.1.1

# goharbor/notary-server-photon
docker pull goharbor/notary-server-photon:v2.1.1 && \
docker tag goharbor/notary-server-photon:v2.1.1 registry.cn-qingdao.aliyuncs.com/wod/notary-server-photon:v2.1.1 && \
docker push registry.cn-qingdao.aliyuncs.com/wod/notary-server-photon:v2.1.1

# goharbor/notary-signer-photon
docker pull goharbor/notary-signer-photon:v2.1.1 && \
docker tag goharbor/notary-signer-photon:v2.1.1 registry.cn-qingdao.aliyuncs.com/wod/notary-signer-photon:v2.1.1 && \
docker push registry.cn-qingdao.aliyuncs.com/wod/notary-signer-photon:v2.1.1

# redis
docker pull redis:4.0.14-alpine && \
docker tag redis:4.0.14-alpine registry.cn-qingdao.aliyuncs.com/wod/redis:4.0.14-alpine && \
docker push registry.cn-qingdao.aliyuncs.com/wod/redis:4.0.14-alpine
```

## images arm64

```bash
# gitlab.wodcloud.com/cloud/awecloud-goharbor-harbor
registry.cn-qingdao.aliyuncs.com/wod/awecloud-harbor-portal-arm64:v2.1.1
registry.cn-qingdao.aliyuncs.com/wod/awecloud-harbor-core-arm64:v2.1.1
registry.cn-qingdao.aliyuncs.com/wod/awecloud-harbor-jobservice-arm64:v2.1.1
registry.cn-qingdao.aliyuncs.com/wod/awecloud-harbor-registryctl-arm64:v2.1.1

# gitlab.wodcloud.com/cloud/awecloud-goharbor-harbor-db
registry.cn-qingdao.aliyuncs.com/wod/awecloud-harbor-db-arm64:v2.1.1

# registry
docker pull registry:2.7.1@sha256:df3e5e623e469600373cb327e8788e4eeb5e4a4c48e58461feb2b0d4c7f3c588 && \
docker tag registry:2.7.1@sha256:df3e5e623e469600373cb327e8788e4eeb5e4a4c48e58461feb2b0d4c7f3c588 registry.cn-qingdao.aliyuncs.com/wod/registry-arm64:2.7.1 && \
docker push registry.cn-qingdao.aliyuncs.com/wod/registry-arm64:2.7.1

# gitlab.wodcloud.com/cloud/chartmuseum
registry.cn-qingdao.aliyuncs.com/wod/awecloud-harbor-chartmuseum-arm64:v2.1.1

# gitlab.wodcloud.com/cloud/clair
registry.cn-qingdao.aliyuncs.com/wod/awecloud-harbor-clair-arm64:v2.1.1

# gitlab.wodcloud.com/cloud/notary
registry.cn-qingdao.aliyuncs.com/wod/awecloud-harbor-notary-server-arm64:v2.1.1
registry.cn-qingdao.aliyuncs.com/wod/awecloud-harbor-notary-signer-arm64:v2.1.1

# redis
docker pull redis:4.0.14-alpine@sha256:2c1fb6d8d5a7626b3c69a1a96f7f2471aece258e1e6d4a3d722ac65e486aba85 && \
docker tag redis:4.0.14-alpine@sha256:2c1fb6d8d5a7626b3c69a1a96f7f2471aece258e1e6d4a3d722ac65e486aba85 registry.cn-qingdao.aliyuncs.com/wod/redis-arm64:4.0.14-alpine && \
docker push registry.cn-qingdao.aliyuncs.com/wod/redis-arm64:4.0.14-alpine
```
