# harbor

## install

```bash
## 打包项目
helm package .

## 部署项目
helm install \
harbor \
/etc/kubernetes/charts/beagle-harbor-2.1.7.tgz \
--namespace beagle-devops \
-f /etc/kubernetes/charts/beagle-harbor.yaml

## 更新项目
helm upgrade \
harbor \
/etc/kubernetes/charts/beagle-harbor-2.1.7.tgz \
--namespace beagle-devops \
-f /etc/kubernetes/charts/beagle-harbor.yaml

## 删除项目
helm uninstall \
--namespace beagle-devops \
harbor

## 测试项目
helm template \
--namespace beagle-devops \
harbor \
/etc/kubernetes/helm/beagle-harbor \
-f /etc/kubernetes/helm/beagle-harbor/values-overrides.yaml > /etc/kubernetes/helm/beagle-harbor/dist.yaml
```

## images x86_64

```bash
# gitlab.wodcloud.com/cloud/awecloud-goharbor-harbor
registry.cn-qingdao.aliyuncs.com/wod/harbor-portal:v2.1.6
registry.cn-qingdao.aliyuncs.com/wod/harbor-core:v2.1.6
registry.cn-qingdao.aliyuncs.com/wod/harbor-jobservice:v2.1.6
registry.cn-qingdao.aliyuncs.com/wod/harbor-registryctl:v2.1.6

# gitlab.wodcloud.com/cloud/awecloud-goharbor-harbor-db
registry.cn-qingdao.aliyuncs.com/wod/harbor-db:v2.1.6

# registry
registry.cn-qingdao.aliyuncs.com/wod/registry:v2.7.1

# gitlab.wodcloud.com/cloud/chartmuseum
registry.cn-qingdao.aliyuncs.com/wod/chartmuseum:v0.12.0

# gitlab.wodcloud.com/cloud/clair
registry.cn-qingdao.aliyuncs.com/wod/clair:v2.1.7

# gitlab.wodcloud.com/cloud/awecloud-goharbor-harbor-scanner-clair
registry.cn-qingdao.aliyuncs.com/wod/harbor-scanner-clair:v1.1.1

# gitlab.wodcloud.com/cloud/harbor-scanner-trivy
registry.cn-qingdao.aliyuncs.com/wod/harbor-scanner-trivy:v0.17.0

# gitlab.wodcloud.com/cloud/notary
registry.cn-qingdao.aliyuncs.com/wod/notary-server:v0.6.1
registry.cn-qingdao.aliyuncs.com/wod/notary-signer:v0.6.1

# redis
registry.cn-qingdao.aliyuncs.com/wod/redis:6.2.6
```

## images arm64

```bash
# gitlab.wodcloud.com/cloud/awecloud-goharbor-harbor
registry.cn-qingdao.aliyuncs.com/wod/harbor-portal:v2.1.6-arm64
registry.cn-qingdao.aliyuncs.com/wod/harbor-core:v2.1.6-arm64
registry.cn-qingdao.aliyuncs.com/wod/harbor-jobservice:v2.1.6-arm64
registry.cn-qingdao.aliyuncs.com/wod/harbor-registryctl:v2.1.6-arm64

# gitlab.wodcloud.com/cloud/awecloud-goharbor-harbor-db
registry.cn-qingdao.aliyuncs.com/wod/harbor-db:v2.1.6-arm64

# registry
registry.cn-qingdao.aliyuncs.com/wod/registry:v2.7.1-arm64

# gitlab.wodcloud.com/cloud/chartmuseum
registry.cn-qingdao.aliyuncs.com/wod/chartmuseum:v0.12.0-arm64

# gitlab.wodcloud.com/cloud/clair
registry.cn-qingdao.aliyuncs.com/wod/clair:v2.1.7-arm64

# gitlab.wodcloud.com/cloud/awecloud-goharbor-harbor-scanner-clair
registry.cn-qingdao.aliyuncs.com/wod/harbor-scanner-clair:v1.1.1-arm64

# gitlab.wodcloud.com/cloud/harbor-scanner-trivy
registry.cn-qingdao.aliyuncs.com/wod/harbor-scanner-trivy:v0.17.0-arm64

# gitlab.wodcloud.com/cloud/notary
registry.cn-qingdao.aliyuncs.com/wod/notary-server:v0.6.1-arm64
registry.cn-qingdao.aliyuncs.com/wod/notary-signer:v0.6.1-arm64

# redis
registry.cn-qingdao.aliyuncs.com/wod/redis:6.2.6-arm64
```
