# images
```bash
# harbor-ui
docker pull goharbor/harbor-ui:v1.6.0 && \
docker tag goharbor/harbor-ui:v1.6.0  registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-ui:v1.6.0  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-ui:v1.6.0 

# harbor-adminserver
docker pull goharbor/harbor-adminserver:v1.6.0 && \
docker tag goharbor/harbor-adminserver:v1.6.0  registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-adminserver:v1.6.0  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-adminserver:v1.6.0 

# harbor-jobservice
docker pull goharbor/harbor-jobservice:v1.6.0 && \
docker tag goharbor/harbor-jobservice:v1.6.0  registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-jobservice:v1.6.0  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-jobservice:v1.6.0 

# harbor-db
docker pull goharbor/harbor-db:v1.6.0 && \
docker tag goharbor/harbor-db:v1.6.0  registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-db:v1.6.0  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-db:v1.6.0 

# chartmuseum
docker pull chartmuseum/chartmuseum:v0.7.1 && \
docker tag chartmuseum/chartmuseum:v0.7.1  registry-vpc.cn-qingdao.aliyuncs.com/wod/chartmuseum:v0.7.1  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/chartmuseum:v0.7.1 

# clair
docker pull quay.io/coreos/clair:v2.0.6 && \
docker tag quay.io/coreos/clair:v2.0.6  registry-vpc.cn-qingdao.aliyuncs.com/wod/clair:v2.0.6  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/clair:v2.0.6

# notary:server
docker pull notary:server-0.5.0 && \
docker tag notary:server-0.5.0  registry-vpc.cn-qingdao.aliyuncs.com/wod/notary-server:0.5.0  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/notary-server:0.5.0

# notary:signer
docker pull notary:signer-0.5.0 && \
docker tag notary:signer-0.5.0  registry-vpc.cn-qingdao.aliyuncs.com/wod/notary-signer:0.5.0  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/notary-signer:0.5.0

# registry
docker pull registry:2.6.2 && \
docker tag registry:2.6.2  registry-vpc.cn-qingdao.aliyuncs.com/wod/registry:2.6.2  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/registry:2.6.2 

# redis
docker pull redis:4.0.1-alpine && \
docker tag redis:4.0.1-alpine  registry-vpc.cn-qingdao.aliyuncs.com/wod/redis:4.0.1-alpine  && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/redis:4.0.1-alpine
```

## overrides
```bash
cat /etc/kubernetes/helm/harbor/values-overrides.yaml
```

```yaml
persistence:
  enabled: true
externalProtocol: https
externalDomain: harbor.wodcloud.local
harborAdminPassword: "58772015"

ingress:
  enabled: false

istio:
  enabled: true  

adminserver:
  image:
    repository: registry.cn-qingdao.aliyuncs.com/wod/harbor-adminserver
    tag: v1.6.0
  volumes:
    config:
      storageClass: "storageos"
      accessMode: ReadWriteOnce
      size: 1Gi

jobservice:
  image:
    repository: registry.cn-qingdao.aliyuncs.com/wod/harbor-jobservice
    tag: v1.6.0

ui:
  image:
    repository: registry.cn-qingdao.aliyuncs.com/wod/harbor-ui
    tag: v1.6.0

busybox:
  image:
    repository: registry.cn-qingdao.aliyuncs.com/wod/busybox
    tag: 1.29

database:
  internal:
    image:
      repository: registry.cn-qingdao.aliyuncs.com/wod/harbor-db
      tag: v1.6.0
    password: "spaceIN511"
    volumes:
      data:
        storageClass: "storageos"
        accessMode: ReadWriteOnce
        size: 1Gi

registry:
  image:
    repository: registry.cn-qingdao.aliyuncs.com/wod/registry
    tag: 2.6.2
  volumes:
    data:
      # storageClass: "-"
      accessMode: ReadWriteOnce
      size: 5Gi
  nodeSelector:
    harbor-registry: enabled

chartmuseum:
  enabled: true
  image:
    repository: registry.cn-qingdao.aliyuncs.com/wod/chartmuseum
    tag: v0.7.1
  volumes:
    data:
      storageClass: "storageos"
      accessMode: ReadWriteOnce
      size: 5Gi

clair:
  enabled: true
  image:
    repository: registry.cn-qingdao.aliyuncs.com/wod/clair
    tag: v2.0.6
  volumes:
    pgData:
      storageClass: "storageos"
      accessMode: ReadWriteOnce
      size: 1Gi

redis:
  image:
    repository: registry.cn-qingdao.aliyuncs.com/wod/redis
    tag: 4.0.1-alpine
  usePassword: false
  cluster:
    enabled: false
  master:
    persistence:
      enabled: false

notary:
  enabled: true
  server:
    image:
      repository: registry.cn-qingdao.aliyuncs.com/wod/notary-server-photon
      tag: dev
  signer:
    image:
      repository: registry.cn-qingdao.aliyuncs.com/wod/notary-signer-photon
      tag: dev
```

## setup
```bash
# 1.install

# label node
kubectl label node <nodename> harbor-registry=enabled

helm install \
/etc/kubernetes/helm/harbor \
--name=harbor \
--namespace=devops \
-f /etc/kubernetes/helm/harbor/values-overrides.yaml

# uninstall
helm delete harbor --purge
```