# harbor

## install

```bash
# 1.install

# label node
kubectl label node <nodename> harbor=enabled

helm install \
/etc/kubernetes/helm/harbor \
--name=harbor \
--namespace=devops \
-f /etc/kubernetes/helm/harbor/values-overrides.yaml

# uninstall
helm delete harbor --purge

# update
helm upgrade harbor /etc/kubernetes/helm/harbor \
-f /etc/kubernetes/helm/harbor/values-overrides.yaml
```

## images

```bash
# goharbor/harbor-portal
docker pull goharbor/harbor-portal:v1.7.5 && \
docker tag goharbor/harbor-portal:v1.7.5 registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-portal:v1.7.5 && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-portal:v1.7.5

# goharbor/harbor-core
docker pull goharbor/harbor-core:v1.7.5 && \
docker tag goharbor/harbor-core:v1.7.5 registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-core:v1.7.5 && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-core:v1.7.5

# goharbor/harbor-adminserver
docker pull goharbor/harbor-adminserver:v1.7.5 && \
docker tag goharbor/harbor-adminserver:v1.7.5 registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-adminserver:v1.7.5 && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-adminserver:v1.7.5

# goharbor/harbor-jobservice
docker pull goharbor/harbor-jobservice:v1.7.5 && \
docker tag goharbor/harbor-jobservice:v1.7.5 registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-jobservice:v1.7.5 && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-jobservice:v1.7.5

# registry
docker pull registry:2.7.1 && \
docker tag registry:2.7.1 registry-vpc.cn-qingdao.aliyuncs.com/wod/registry:2.7.1 && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/registry:2.7.1

# goharbor/harbor-registryctl
docker pull goharbor/harbor-registryctl:v1.7.5 && \
docker tag goharbor/harbor-registryctl:v1.7.5 registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-registryctl:v1.7.5 && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-registryctl:v1.7.5

# goharbor/chartmuseum-photon
docker pull goharbor/chartmuseum-photon:v0.8.1-v1.7.5 && \
docker tag goharbor/chartmuseum-photon:v0.8.1-v1.7.5 registry-vpc.cn-qingdao.aliyuncs.com/wod/chartmuseum-photon:v0.8.1-v1.7.5 && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/chartmuseum-photon:v0.8.1-v1.7.5

# goharbor/clair-photon
docker pull goharbor/clair-photon:v2.0.8-v1.7.5 && \
docker tag goharbor/clair-photon:v2.0.8-v1.7.5 registry-vpc.cn-qingdao.aliyuncs.com/wod/clair-photon:v2.0.8-v1.7.5 && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/clair-photon:v2.0.8-v1.7.5

# goharbor/notary-server-photon
docker pull goharbor/notary-server-photon:v0.6.1-v1.7.5 && \
docker tag goharbor/notary-server-photon:v0.6.1-v1.7.5 registry-vpc.cn-qingdao.aliyuncs.com/wod/notary-server-photon:v0.6.1-v1.7.5 && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/notary-server-photon:v0.6.1-v1.7.5

# goharbor/notary-signer-photon
docker pull goharbor/notary-signer-photon:v0.6.1-v1.7.5 && \
docker tag goharbor/notary-signer-photon:v0.6.1-v1.7.5 registry-vpc.cn-qingdao.aliyuncs.com/wod/notary-signer-photon:v0.6.1-v1.7.5 && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/notary-signer-photon:v0.6.1-v1.7.5

# goharbor/harbor-db
docker pull goharbor/harbor-db:v1.7.5 && \
docker tag goharbor/harbor-db:v1.7.5 registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-db:v1.7.5 && \
docker push registry-vpc.cn-qingdao.aliyuncs.com/wod/harbor-db:v1.7.5
```