# Upgrade Guide

This guide is used to upgrade Harbor deployed by chart since version 0.3.0.  

**Notes**:
- As the database schema may change between different versions of Harbor, there is a progress to migrate the schema during the upgrade and the downtime cannot be avoid  
- The database schema cannot be downgraded automatically, so the `helm rollback` is not supported  

## Upgrade
1. **Backup database**  
Backup the database used by Harbor in case the upgrade process fails.  
2. **Download new chart**  
Download the latest version of Harbor chart.  
3. **Configure new chart**  
Configure the new chart to make sure that the configuration items have the same values with the old one.  

    **Note**: if TLS is enabled and the certificate is generated by chart automatically, a new certificate will be generated and overwrite the old one during the upgrade, this may cause some issues if you have distributed the certificate. You can follow the below steps to configure the new chart to use the old certificate:  

    1) Get the secret name which certificate is stored in:
        ```
        kubectl get secret
        ```  
        Find the secret whose name ends with `-harbor-ingress`(expose service via `Ingress`) or `-harbor-nginx`(expose service via `ClusterIP` or `NodePort`)  

    2) Export the secret as yaml file:  
        ```
        kubectl get secret secret-name -o yaml > secret.yaml
        ```  
        Replace the `secret-name` with the one got in step i  

    3) Rename the secret by setting `metadata.name` in `secret.yaml`  
   
    4) Create a new secret:  
        ```
        kubectl create -f secret.yaml
        ```  

    5) Configure the chart to use the new secret by setting `expose.tls.secretName` as the value you set in step iii  

4. **Upgrade**  
Run upgrade command:  
    ```
    helm upgrade release-name --force .
    ```  
    The `--force` is necessary if upgrade from version 0.3.0 due to issue [#30](https://github.com/goharbor/harbor-helm/issues/30).  

## Known issues
- The job logs will be lost if you upgrade from version 0.3.0 as the logs are store in a `emptyDir` in 0.3.0.  
