var adminMenu = [
  {
    menuName: "工作台",
    path: "/workspace",
    parentPath:null,
    name:"workspace",
    menuType:'system', //system:apaas后管,能力注册页等  font:apaas前台页  manager:apaas管理中心
    show:true,
    level:1,
    children:[{
      menuName: "能力管理",
      path: "/ability-manage",
      show:true,
      menuType:'system',
      icon: "#bg-ic-ability",
      parentPath:'/workspace',
      children:[
        {
          name: "ui-service-test",
          menuName: "ui服务测试",
          path: "/ui-example",
          menuType:'system',
          parentPath:null,
        },
        {
          name: "register-valid",
          menuName: "注册认证",
          path: "/register-valid",
          menuType:'system',
          parentPath:null,
        },
        {
          name: "ability-register-step",
          menuName:'能力注册',
          path: "/ability-register/step",
          parentPath:'/ability-manage',
          menuType:'system',
        },
        {
          name: "ability-register-desc",
          menuName:'服务注册说明',
          path: "/ability-register/desc",
          linkPath:["/ability-register/desc"],
          parentPath:'/ability-manage',
          menuType:'system',
        },
        {
          name: "ability-register-preview",
          menuName:'服务注册说明',
          path: "/ability-register/preview",
          linkPath:["/ability-register/preview"],
          parentPath:'/ability-manage',
          menuType:'system',
        },
        {
          name: "ability-register-set-mock",
          menuName:'配置mock服务',
          path: "/ability-register/set-mock",
          parentPath:'/ability-manage',
          menuType:'system',
        },
        {
          name: "real-list",
          menuName:'能力注册',
          path: "/ability-manage/real-list",
          parentPath:'/ability-manage',
          linkPath:["/ability-register/step","/ability-register/set-mock"],
          menuType:'system',
          show:true,
        },
        {
          name: "real-detail",
          menuName:'能力注册详情',
          path: "/ability-manage/real-list/detail",
          parentPath:'/ability-manage',
          menuType:'system',
        },
        {
          name: "mock-list",
          menuName:'mock能力',
          path: "/ability-manage/mock-list",
          parentPath:'/ability-manage',
          linkPath:["/mock-register/step"],
          show:true,
          menuType:'system',
        },
        {
          path:"/mock-register/step",
          parentPath:'/ability-manage',
          name:"mock-register-step",
          menuName:"mock注册",
          menuType:'system',
        },
        {
          name: "mock-detail",
          menuName:'mock能力详情',
          path: "/ability-manage/mock-list/detail",
          parentPath:'/ability-manage',
          menuType:'system',
        },
        {
          name: "sold-list",
          menuName:'能力上下架管理',
          path: "/ability-manage/sold-list",
          parentPath:'/ability-manage',
          linkPath:["/ability-manage/sold-list/service-test"],
          show: true,
          menuType:'system',
        },
        {
          name: "service-test",
          menuName:'服务测试',
          path: "/ability-manage/sold-list/service-test",
          parentPath:'/ability-manage',
          menuType:'system',
        },
        
      ]
    },
    {
      name: "dict-config",
      menuName:'字典配置',
      path: "/dict-config",
      parentPath:'/workspace',
      menuType:'system',
      icon: "#bg-ic-log",
      show:true,
      children: [
        {
          name: "business-list",
          menuName:'业务分类',
          path: "/dict-config/business-list",
          parentPath:'/dict-config',
          menuType:'system',
          show:true,
        },
        {
          name: "sectors-list",
          menuName:'业务领域',
          path: "/dict-config/sectors-list",
          parentPath:'/dict-config',
          menuType:'system',
          show:true,
        },
        {
          name: "openness-list",
          menuName:'开放程度',
          path: "/dict-config/openness-list",
          parentPath:'/dict-config',
          menuType:'system',
          show:true,
        }
      ]
    }
]
},

    {
      menuName: "管理中心",
      path: "/manage",
      name:"manage",
      parentPath:null,
      menuType:'manager',
      show: true,
      level:1,
      children:[{
        menuName: "开发管理",
        path: "/develop",
        parentPath:null,
        menuType:'manager',
        show:true,
        icon: "#bg-ic-ability",
        children:[
          {
            name: "account-manage",
            menuName:'系统账号管理',
            parentPath:null,
            menuType:'manager',
            show:true,
            path: "/develop/account",
            linkPath: ["/develop/account/add"]
          },
          {
            name: "account-add-manage",
            menuName:'新建账号',
            parentPath:'/develop/account',
            menuType:'manager',
            path: "/develop/account/add",
          },
          {
            name: "account-detail-manage",
            menuName:'账号详情',
            parentPath: '/develop/account',
            menuType:'manager',
            path: "/develop/account/detail",
          },
          {
            name: "menu-manage",
            menuName:'菜单管理',
            parentPath:null,
            menuType:'manager',
            show:true,
            path: "/develop/menu",
          },
          
        ]
      },
      {
        menuName: "系统管理",
        path: "/system",
        parentPath:null,
        menuType:'manager',
        show:true,
        icon: "#bg-ic-ability",
        children:[
          {
            name: "system-manage",
            menuName:'组织管理',
            parentPath:null,
            menuType:'manager',
            show:true,
            path: "/system/organization",
          },
          {
            name: "paltform-user-manage",
            menuName:'新增平台用户',
            parentPath: '/system/organization',
            menuType:'manager',
            show:false,
            path: "/system/organization/platform-user",
          },
          {
            name: "system-user-manage",
            menuName:'新增组织用户',
            parentPath: '/system/organization',
            menuType:'manager',
            show: false,
            path: "/system/organization/system-user",
          },
          {
            name: "user-detail-manage",
            menuName:'用户详情',
            parentPath: '/system/organization',
            menuType:'manager',
            show: false,
            path: "/system/organization/user-detail",
          },
          {
            name: "org-detail-manage",
            menuName:'组织详情',
            parentPath: '/system/organization',
            menuType:'manager',
            show: false,
            path: "/system/organization/org-detail",
          },
          {
            name: "role-manage",
            menuName:'角色管理',
            parentPath:null,
            menuType:'manager',
            show:true,
            path: "/system/role",
          },
          
        ]
      },
      {
        menuName: "配置管理",
        path: "/config",
        parentPath:null,
        menuType:'manager',
        show:true,
        icon: "#bg-ic-ability",
        children:[
          {
            name: "dict-manage",
            menuName:'字典管理',
            parentPath:null,
            menuType:'manager',
            show:true,
            path: "/config/dict",
          },
          
        ]
      },
  ]
  },
  {
    name:"index",
    menuName:"首页",
    path: "/",
    parentPath:null,
    menuType:'font',
    level:1,
    show:true,
    
  },
]


function getViews(path) {
// 首先把你需要动态路由的组件地址全部获取,示例项目主项目放入了main，如果直接放入page，需要去掉/main
let pathArr = path.split('/')
let modules = {}
switch (pathArr.length) {
  case 2:
    modules = import.meta.glob('../page/main/**/*.vue')
    break;
  case 3:
    modules = import.meta.glob('../page/main/**/*/*.vue')
    break;
  case 4:
    modules = import.meta.glob('../page/main/**/**/*/*.vue')
    break;
  case 5:
    modules = import.meta.glob('../page/main/**/**/**/*/*.vue')
    break;
  default:
    break;
}
// 然后动态路由的时候这样来取
console.log(modules['../page/main' + path + '/index.vue']);
return modules['../page/main' + path + '/index.vue']
}

//处理路由方法
var menuToRouter = (menu)=>{
menu.forEach(e => {
  //第一层级是最上层菜单，有相应的菜单可以点击查看
  if(e.children&&e.level==1){
    console.log(`@/page/main${e.path}/index.vue`);
    e.component= getViews(e.path)
    menuToRouter(e.children)
  }else if(e.children){
    // 其他层级作为文件夹，只提供父级
    e.component = () => import('../page/parent/parent.vue')
    menuToRouter(e.children)
  }else{
    console.log(`@/page/main${e.path}/index.vue`);
    //叶子层级需要加载到对应文件
    //对首页做兼容
    if(e.path=='/'){
      e.component = () => import('../page/main/develop/account/index.vue')
    }else{
      e.component= getViews(e.path)
    }
  }
});
}

export default {
  adminMenu,
  menuToRouter
}