import axios from "@/request/http.js";
export const TIMEING_RULES = {
    1: '手动下发',
    2: '按周',
    3: '自定义时间'
}
export const MAX_DAY = 7;
export const WIELESS_SMALL = '-∞'
export const WIELESS_BIG = '+∞'
export const ONLY_INPUT_NUM = (value) => {
    return value.replace(/[^\d]/g, '')
}
export const GetRuleTypeOptions = () => {
    return new Promise((resolve, reject) => {
        const params = {
            page: 1,
            page_size: 10000000000000,
            class: 3,
        };
        let obj = {}
        axios.get(`/v1/api/dict`, { params }).then((res) => {
            if (res.data.code == 200) {
                if (res.data.data) {
                    res.data.data.forEach((e) => {
                        let isEmptyOption = e.name == "空";
                        obj[e.id] = {
                            label: e.name,
                            unit: isEmptyOption ? "" : e.unit,
                            down: isEmptyOption ? '' : e.min_val,
                            up: isEmptyOption ? '' : e.max_val
                        };
                    });
                }
                resolve(obj)
            }
        });
    })
}
export const Empty = (key, Obj) => {
    let item = Obj[key]
    return !item || item.label == '空'
}
export const dateStringToDate = (str) => {
    if (!str || typeof str != 'string') return str || "-";
    return str.split("+")[0].replace("T", " ").replace("Z", " ")
}
export const delay = (time = 1000) => new Promise((resolve, reject) => setTimeout(resolve, time))