/**
 * 优先级高于.editorconfig
 * https://prettier.io/docs/en/options.html
 * 单引号，双引号，末尾是否逗号，是否需要分号根据团队需要配置
 * 但是prettier对vue template的格式化能力有限，建议多观察是否满足需要，最佳实践还是要结合eslint进行风格统一
 */
module.exports = {
  arrowParens: "always",
  bracketSameLine: true, // https://prettier.io/docs/en/options.html#bracket-line
  bracketSpacing: true,
  embeddedLanguageFormatting: "auto",
  htmlWhitespaceSensitivity: "css",
  insertPragma: false,
  jsxSingleQuote: false,
  printWidth: 120, // 如果属性过多需要换行，减少该值
  proseWrap: "preserve",
  quoteProps: "as-needed",
  requirePragma: false,
  semi: true,
  singleAttributePerLine: false,
  singleQuote: false, // 双引号
  tabWidth: 2, // 缩进
  trailingComma: "es5",
  useTabs: false, // 不要用tab缩进
  vueIndentScriptAndStyle: false,
  endOfLine: "lf",
};
