var adminMenu = [
  {
    menuName: "工作台",
    path: "/workspace1",
    dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25", //0目录1菜单2子页面
    menuType: 0, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
    children: [
      {
        menuName: "工作台首页",
        path: "/workspace",
        dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25",
        menuType: 1, //system:apaas后管,能力注册页等  font:apaas前台页  manager:apaas管理中心
      },
      {
        menuName: "能力管理",
        path: "/ability-manage",
        dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25",
        menuType: 0,
        icon: "bg-ic-ability",
        children: [
          {
            menuName: "能力注册",
            path: "/ability-manage/real-list",
            children: [
              {
                menuName: "能力注册",
                path: "/ability-register/step",
                dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25",
                menuType: 2,
                children: [
                  {
                    menuName: "服务注册说明",
                    path: "/ability-register/desc",
                    dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25",
                    menuType: 2,
                  },
                  {
                    menuName: "服务注册预览",
                    path: "/ability-register/preview",
                    dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25",
                    menuType: 2,
                  },
                  {
                    menuName: "注册认证",
                    path: "/register-valid",
                    dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25",
                    menuType: 2,
                  },
                ],
              },
              {
                menuName: "配置mock服务",
                path: "/ability-register/set-mock",
                dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25",
                menuType: 2,
              },
              {
                menuName: "能力注册详情",
                path: "/ability-manage/real-list/detail",
                dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25",
                menuType: 2,
              },
            ],
            dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25",
            menuType: 1,
          },
          {
            menuName: "mock能力",
            path: "/ability-manage/mock-list",
            children: [
              {
                path: "/mock-register/step",
                menuName: "mock注册",
                dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25",
                menuType: 2,
              },
              {
                menuName: "mock能力详情",
                path: "/ability-manage/mock-list/detail",
                dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25",
                menuType: 2,
              },
            ],
            dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25",
            menuType: 1,
          },
          {
            menuName: "能力上下架管理",
            path: "/ability-manage/sold-list",
            children: [
              {
                menuName: "服务测试",
                path: "/ability-manage/sold-list/service-test",
                dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25",
                menuType: 2,
                children: [
                  {
                    menuName: "ui服务测试",
                    path: "/ui-example",
                    dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25",
                    menuType: 2,
                  },
                ],
              },
            ],
            dict_group_id: "64c156e0-bfff-4bfc-a63a-56effe130a25",
            menuType: 1,
          },
        ],
      },
    ],
  },
  {
    menuName: "首页",
    path: "/",
    dict_group_id: "2cb4f767-fad7-44f2-afa3-f055e15dd2b6",
    menuType: 1, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
  },
  {
    menuName: "管理中心",
    path: "/manage",
    dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
    menuType: 0, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
    children: [
      {
        menuName: "开发管理",
        path: "/develop",
        dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
        menuType: 0, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
        icon: "bg-ic-ability",
        children: [
          {
            menuName: "系统账号管理",
            dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
            menuType: 1, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
            path: "/develop/account",
            children: [
              {
                menuName: "新增账号",
                dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
                menuType: 2, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
                path: "/develop/account/add",
              },
              {
                menuName: "账号详情",
                dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
                menuType: 2, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
                path: "/develop/account/detail",
              },
            ],
          },
          {
            menuName: "菜单管理",
            dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
            menuType: 1, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
            path: "/develop/menu",
          },
        ],
      },
      {
        menuName: "系统管理",
        path: "/system",
        dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
        menuType: 0, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
        icon: "bg-ic-ability",
        children: [
          {
            menuName: "组织管理",
            dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
            menuType: 1, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
            path: "/system/organization",
            children: [
              {
                menuName: "新增平台用户",
                dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
                menuType: 2, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
                show: false,
                path: "/system/organization/platform-user",
              },
              {
                menuName: "新增组织用户",
                dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
                menuType: 2, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
                show: false,
                path: "/system/organization/org-user",
              },
              {
                menuName: "用户详情",
                dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
                menuType: 2, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
                show: false,
                path: "/system/organization/user-detail",
              },
              {
                menuName: "组织详情",
                dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
                menuType: 2, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
                show: false,
                path: "/system/organization/org-detail",
              },
            ],
          },
          {
            menuName: "角色管理",
            dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
            menuType: 1, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
            path: "/system/role",
            children: [
              {
                menuName: "新增角色",
                menuType: 2,
                dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
                path: "/system/role/add",
              },
              {
                menuName: "编辑角色",
                menuType: 2,
                dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
                path: "/system/role/edit",
              },
            ],
          },
        ],
      },
      {
        menuName: "配置管理",
        path: "/config",
        dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
        menuType: 0, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
        icon: "bg-ic-ability",
        children: [
          {
            menuName: "字典管理",
            dict_group_id: "09938937-3db9-47de-b967-7777ea4ebb2d",
            menuType: 1, //system:64c156e0-bfff-4bfc-a63a-56effe130a25:apaas后管,能力注册页等  font:2cb4f767-fad7-44f2-afa3-f055e15dd2b6:apaas前台页  manager:09938937-3db9-47de-b967-7777ea4ebb2d:apaas管理中心 知识中心：26d3903a-863e-4efc-b53e-0fb8772ddaa4
            path: "/config/dict",
          },
        ],
      },
    ],
  },
];

function getName(str) {
  if (str == "/") {
    return "index";
  }
  let temp = str.slice(1);
  temp = temp.replaceAll("/", "-");
  return temp;
}

function getViews(path) {
  // 首先把你需要动态路由的组件地址全部获取,示例项目主项目放入了main，如果直接放入page，需要去掉/main
  let pathArr = path.split("/");
  let modules = {};
  switch (pathArr.length) {
    case 2:
      modules = import.meta.glob("../page/main/**/*.vue");
      break;
    case 3:
      modules = import.meta.glob("../page/main/**/*/*.vue");
      break;
    case 4:
      modules = import.meta.glob("../page/main/**/**/*/*.vue");
      break;
    case 5:
      modules = import.meta.glob("../page/main/**/**/**/*/*.vue");
      break;
    default:
      break;
  }
  // 然后动态路由的时候这样来取
  return modules["../page/main" + path + "/index.vue"];
}

//处理路由方法
var menuToRouter = (menu) => {
  menu.forEach((e) => {
    e.name = getName(e.path);
    if (e.children && e.menuType == 0) {
      // 其他层级作为文件夹，只提供父级
      e.component = () => import("../page/parent/parent.vue");
      menuToRouter(e.children);
    } else if (e.children && e.menuType !== 0) {
      //叶子层级需要加载到对应文件
      //对首页做兼容
      if (e.source) {
        e.component = getViews(e.source);
      } else {
        e.component = getViews(e.path);
      }
      menuToRouter(e.children);
    } else {
      //叶子层级需要加载到对应文件
      //对首页做兼容
      if (e.path == "/") {
        if (e.source) {
          e.component = () => import(`../page/main/${e.source}/index.vue`);
        } else {
          e.component = () => import("../page/main/index/index.vue");
        }
      } else {
        if (e.source) {
          e.component = getViews(e.source);
        } else {
          e.component = getViews(e.path);
        }
      }
    }
  });
};

export default {
  adminMenu,
  menuToRouter,
};
