import { ElMessage } from "element-plus";
import axios from "@/request/http.js";
const setParams = (res, { id }) => {
    let isEmpty = res.type_com_ref.isEmpty
    let params = {
        // 预警规则名称
        metric_name: res.name,
        // 持续时间
        duration: +res.time,
        // 持续时间单位
        duration_unit: res.unit,
        // 检查周期
        check_period: +res.inspection_cycle,
        // 预警通知方式
        notify_method: res.manual_distribution_form.method,
        // 预警通知人员列表
        notify_recipients: res.manual_distribution_form.lists.map(e => {
            return {
                system_account: `${e.user_id}`,
                user_name: `${e.user_name}`,
                phone: `${e.phone}`
            }
        }),
        // 消息推送次数
        notify_push_count: +res.push_num,
        // 消息推送频率
        notify_push_frequency: +res.push_frequency,
        // 是否立即启用
        is_enabled: res.enabled ? 1 : 2
    }
    let params_push = {
        // 自定义传参
        custom: () => {
            return {
                detection_type: 2,
                // 预警分类
                class_parent_name: res.type_com_ref.warn_target,
                // 预警对象
                class_name: res.type_com_ref.warn_type,
                // 预警指标
                metric_config_name: res.type_com_ref.warn_indicator,
                // 指标表达式
                expr: res.type_com_ref.indicator_expression || "",
                // 预警规则(下拉)
                alert_rule_type: res.type_com_ref.rule_type,
                // 预警规则对象数组
                alert_condition,
                alert_range: []
            }
        },
        // 静态阈值传参
        static: () => {
            return {
                detection_type: 1,
                // 预警对象
                class_id: +res.type_com_ref.warn_type,
                metric_config_id: res.type_com_ref.warn_indicator,
                // 报警范围（指标）
                alert_range: res.type_com_ref.warning_scpoe_form.map(e => {
                    return {
                        variable_name: e.variable_name,
                        metric_name: e.metric_name,
                        chinese_name: e.chinese_name,
                        metric_label: e.metric_label,
                        is_required: e.is_required,
                        is_linked: e.is_linked,
                        value: e.select == 'all' ? '.*' : e.value,
                        compare: e.select == 'all' ? '=~' : e.select
                    }
                }),
                // 预警规则(下拉)
                alert_rule_type: res.type_com_ref.alert_rule_type,
            }
        }
    }
    let alert_condition = []
    if (isEmpty) {
        alert_condition = [{
            thresholds_max: 0,
            thresholds_min: 0,
            risk_level: +res.type_com_ref.risk_level
        }]
    } else {
        alert_condition = res.type_com_ref.ruleRows.map(e => {
            let obj = {
                risk_level: +e.risk_level
            }
            if (e.to !== "") {
                obj.thresholds_max = +e.to
            }
            if (e.from !== "") {
                obj.thresholds_min = +e.from
            }
            return obj
        })
    }
    params = {
        ...params,
        ...params_push[res.type_key](),
        // 预警规则对象数组
        alert_condition,
    }
    if (id) {
        params.id = id
    }
    return params;
}
export const Save = (res, p, cb) => {
    let params = setParams(res, p);
    axios[p.id ? 'put' : 'post']('/v1/api/alert_rules', params).then(res => {
        if (res.data.code == 200) {
            ElMessage.success(`${p.id ? '编辑' : '新增'}成功`)
            cb && cb()
        } else {
            ElMessage.error(res.data.data)
        }
    })
}