import { ElMessage } from "element-plus";
import axios from "@/request/http.js";
const setParams = ({ res, is_push }, { id }) => {
    let params = {
        is_push: is_push,
        order_name: res.ticket_name,
        order_level: +res.ticket_level,
        order_desc: res.ticket_desc,
        timing_type: +res.timing_rules,
        push_obj: {
            push_method: res.method.length > 1 ? 3 : +res.method[0],
            user_obj: res.lists.map(e => {
                return {
                    system_account: e.user_id,
                    user_name: e.user_name,
                    phone: e.phone
                }
            })
        }
    }
    let ruleObj = {
        1: {},
        2: {
            timing_weekly: {
                week: res.rule_ref.week_days,
                point_time: res.rule_ref.time
            }
        },
        3: {
            timing_custom: !res.rule_ref.rules ? [] : res.rule_ref.rules.map(e => {
                return {
                    date_from: e.date[0] || '',
                    date_to: e.date[1] || '',
                    point_time: e.time
                }
            })
        }
    }
    params = {
        ...params,
        ...ruleObj[res.timing_rules]
    }
    if (id) {
        params.id = +id
    }
    return params;
}
export const Save = (res, p, cb) => {
    let params = setParams(res, p);
    axios[p.id ? 'put' : 'post'](p.url, params).then(res => {
        if (res.data.code == 200) {
            ElMessage.success(`${p.id ? '编辑' : '新增'}成功`)
            cb && cb()
        } else {
            ElMessage.error(res.data.data)
        }
    })
}