import axios from "@/request/http"; // 导入http中创建的axios实例

const autoMaintenance = {
  getHostManageList(params) {
    return axios({
      method: "get",
      baseURL: "/v1",
      url: `/api/automated_mainten/host_manage/page_list`,
      params,
    });
  },
  getHostManageDetail(id) {
    return axios({
      method: "get",
      baseURL: "/v1",
      url: `/api/automated_mainten/host_manage/details?id=${id}`,
    });
  },
  postHostManageState(data) {
    return axios({
      method: "post",
      baseURL: "/v1",
      url: `/api/automated_mainten/host_manage/state`,
      data,
      headers: {
        "Content-Type": "multipart/form-data",
      },
      timeout: 0,
    });
  },
  getHostManageIPExceptionList(params) {
    return axios({
      method: "get",
      baseURL: "/v1",
      url: `/api/automated_mainten/host_manage/ip_exception_list`,
      params,
    });
  },
  postHostManageAdd(data) {
    return axios({
      method: "post",
      baseURL: "/v1",
      url: `/api/automated_mainten/host_manage/add`,
      data,
    });
  },
  putHostManageEdit(data) {
    return axios({
      method: "put",
      baseURL: "/v1",
      url: `/api/automated_mainten/host_manage/edit`,
      data,
    });
  },
  uploadHostManageFile(data) {
    return axios({
      method: "post",
      baseURL: "/v1",
      url: `/api/add_file`,
      data,
      headers: {
        "Content-Type": "multipart/form-data",
      },
    });
  },
  deleteHostManage(data) {
    return axios({
      method: "delete",
      baseURL: "/v1",
      url: `/api/automated_mainten/host_manage/del`,
      data,
    });
  },
};

export default autoMaintenance;
