import { createStore } from "vuex";

const store = createStore({
  state: {
    userInfo: null,
    menu: null,
    route: null,
    nameFlag: false,
    msgBoxFlag: false,
    nowzz: null,
    menuObj: {},
    treeFlag: false,
    registerValid: false,
    msgUnreadNum: 0,
    systemLogo: "",
    whiteList: [],
    userTypeConfig: {
      1: "业务系统账号",
      2: "组织管理员账号",
      3: "平台用户账号",
      4: "超级管理员",
    },
  },
  getters: {
    count(state) {
      return state.userInfo;
    },
    getUserTypeConfig(state) {
      return state.userTypeConfig;
    },
  },
  mutations: {
    setUserInfo(state, info) {
      state.userInfo = info;
    },
    setMenu(state, menu) {
      state.menu = menu;
    },
    setMenuObj(state, menuObj) {
      state.menuObj = menuObj;
    },
    setRoute(state, route) {
      state.route = route;
    },
    setNameFlag(state, nameFlag) {
      state.nameFlag = nameFlag;
    },
    setMsgBoxFlag(state, msgBoxFlag) {
      state.msgBoxFlag = msgBoxFlag;
    },
    setNowzz(state, nowzz) {
      state.nowzz = nowzz;
    },
    setTreeFlag(state, treeFlag) {
      state.treeFlag = treeFlag;
    },
    setRegisterValid(state, registerValid) {
      state.registerValid = registerValid;
    },
    setUnreadNum(state, num) {
      state.msgUnreadNum = num;
    },
    setSystemLogo(state, logo) {
      state.systemLogo = logo;
    },
    setWhiteList(state, arr) {
      state.whiteList = arr;
    },
  },
  actions: {},
});
export default store;
