import msg from './lib/msg.vue'

let option = null

const setAppID = (appID)=>{
  option.appID = appID
}

const setSecretKey = (secretKey)=>{
  option.secretKey = secretKey
}

const setRequestUrl = (requestUrl)=>{
  option.requestUrl = requestUrl
}

const setOptionValue = (opt,val)=>{
  option[opt] = val
}

const methods = {
  setAppID,
  setSecretKey,
  setRequestUrl,
  setOptionValue,
}

const init = (options = {}) => {
  const _options = {
    requestUrl: '', // 请求地址
    appID: '', // 应用id
    secretKey: '', // 应用密钥
    userId:'',
    userType:'',
    roleId:'',
    organization:'',
  };

  // 将传过来的参数转换
  transitionOptions(_options, options);

  option = _options
}

const transitionOptions = (_options, options) => {
  const {
    requestUrl,
    appID,
    secretKey,
    userId,
    userType,
    roleId,
    organization,
  } = options;

  if (!requestUrl) throw Error('请传入requestUrl参数');
  if (!appID) throw Error('请传入appID参数');
  // if (!secretKey) throw Error('secretKey');

  _options.requestUrl = requestUrl;
  _options.appID = appID;
  _options.secretKey = secretKey;
  _options.userId = userId;
  _options.userType = userType;
  _options.roleId = roleId;
  _options.organization = organization;

}

const install = (Vue, options = {}) => {
  init(options);
  if (Vue.prototype) {
    Vue.prototype.$trace = { ...methods,option };
  } else {
    Vue.config.globalProperties.$trace = { ...methods,option };
  }

  Vue.component('msg', msg);
}

if (typeof window !== "undefined" && window.Vue) {
  install(window.Vue);
}

export default {
  install,
  init,
  ...methods
};
export { install, init, methods };