import { ElMessage } from "element-plus";
import axios from "@/request/http.js";
const setParams = (res, { id, class_id }) => {
  let params = {
    class_id: +class_id,
    metric_name: res.name,
    expr: res.indicator_expression,
    alert_range:
      res.warningScopeRows.map((e) => {
        return {
          variable_name: e.key,
          metric_name: e.indicator_scope,
          metric_label: e.indicator_tag,
          chinese_name: e.cname,
          is_required: e.is_required == 1,
          is_linked: e.is_linkage == 1,
        };
      }) || [],
    duration: +res.time,
    duration_unit: res.unit,
    check_period: res.inspection_cycle,
    is_enabled: res.state,
    alert_rule_type: res.rule_type,
  };
  if (id) {
    params.id = id;
  }
  return params;
};
export const Save = (res, p, cb) => {
  let params = setParams(res, p);
  axios[p.id ? "put" : "post"]("/v1/api/metric_config", params).then((res) => {
    if (res.data.code == 200) {
      ElMessage.success(`${p.id ? "编辑" : "新增"}成功`);
      cb && cb();
    } else {
      ElMessage.error(res.data.data);
    }
  });
};
