package entity

import "gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"

type PushRecord struct {
	Id            int           `json:"id" xorm:"'id' pk autoincr"`             // 主键id
	AlertRulesId  string        `json:"alert_rules_id" xorm:"'alert_rules_id'"` // 告警规则id
	RiskLevel     int           `json:"risk_level" xorm:"'risk_level'"`         // 风险等级，1:低风险，2:一般风险，3:较大风险，4:重大风险
	NotifyMethod  string        `json:"notify_method" xorm:"'notify_method'"`   // 预警通知方式 dingtalk sms
	SystemAccount string        `json:"system_account"   xorm:"system_account"` // 预警推送用户
	PushTime      jsontime.Time `json:"push_time" xorm:"'push_time'"`           // 推送时间
	PushType      int           `json:"push_type" xorm:"'push_type'"`           // 推送类型，1:自动推送，2:手动推送
	Status        int           `json:"status" xorm:"'status'"`                 // 推送状态，1:成功，2:失败
	CreatedBy     string        `json:"created_by" xorm:"'created_by'"`         // 创建人
	CreatedAt     jsontime.Time `json:"created_at" xorm:"'created_at'"`         // 创建时间
	UpdatedBy     string        `json:"updated_by" xorm:"'updated_by'"`         // 更新人
	UpdatedAt     jsontime.Time `json:"updated_at" xorm:"'updated_at'"`         // 更新时间
}
