package entity

import "time"

type WorkOrder struct {
	Id          int       `json:"id" xorm:"pk autoincr" `           // id
	OrderName   string    `json:"order_name" xorm:"order_name"`     // 工单名称
	OrderLevel  int       `json:"order_level" xorm:"order_level"`   // 工单等级(1紧急任务 2重要任务 3一般任务)
	OrderDesc   string    `json:"order_desc" xorm:"order_desc"`     // 工单描述
	OrderCnt    int       `json:"order_cnt" xorm:"order_cnt"`       // 实例工单数
	PushObj     string    `json:"push_obj" xorm:"push_obj"`         // 推送对象
	TimingType  int       `json:"timing_type" xorm:"timing_type"`   // 定时类型（1手动下发 2按周 3自定义时间）
	TimingRule  string    `json:"timing_rule" xorm:"timing_rule"`   // 定时规则
	TimingState int       `json:"timing_state" xorm:"timing_state"` // 定时状态（0禁用 1启用）
	CreateUser  string    `json:"create_user"  xorm:"create_user" ` // 创建人
	CreateTime  time.Time `json:"create_time" xorm:"create_time" `  // 创建时间
	UpdateUser  string    `json:"update_user"  xorm:"update_user"`  // 修改人
	UpdateTime  time.Time `json:"update_time" xorm:"update_time" `  // 修改时间
}

type WorkOrderIssuance struct {
	Id            int       `json:"id" xorm:"pk autoincr" `               // id
	OrderId       int       `json:"order_id" xorm:"order_id"`             // 工单id
	PushObj       string    `json:"push_obj" xorm:"push_obj"`             // 下发对象
	OrderState    int       `json:"order_state" xorm:"order_state"`       // 工单状态(1待处置 2已完成 3已关闭)
	ReasonClosure string    `json:"reason_closure" xorm:"reason_closure"` // 关闭原因
	CreateUser    string    `json:"create_user"  xorm:"create_user" `     // 创建人
	CreateTime    time.Time `json:"create_time" xorm:"create_time" `      // 创建时间
	CompleteTime  time.Time `json:"complete_time" xorm:"complete_time" `  // 完成时间
}

type WorkOrderMe struct {
	Id              int       `json:"id" xorm:"pk autoincr" `                     // id
	OrderId         int       `json:"order_id" xorm:"order_id"`                   // 工单id
	OrderIssuanceId int       `json:"order_issuance_id" xorm:"order_issuance_id"` // 工单下发表id
	SystemAccount   string    `json:"system_account" xorm:"system_account"`       // 用户账号
	OrderState      int       `json:"order_state" xorm:"order_state"`             // 工单状态(1待处置 2已完成 3已关闭)
	CompleteTime    time.Time `json:"complete_time"  xorm:"complete_time" `       // 完成时间
	ResultFeedback  string    `json:"result_feedback" xorm:"result_feedback" `    // 结果反馈
}
