package request

type AddAlertOverview struct {
	ClassName  string `json:"class_name" form:"class_name" binding:"required"`
	ParentId   int    `json:"parent_id" form:"parent_id" binding:"omitempty,oneof=0 1"`
	SortOrder  int    `json:"sort_order" form:"sort_order"`
	SourceFrom int    `json:"source_from" form:"source_from" binding:"omitempty,oneof=1 2"` // 数据来源 1:默认 2:自定义
}

type UpdateAlertOverview struct {
	ClassId   int    `json:"class_id" form:"class_id" binding:"required"`
	ClassName string `json:"class_name" form:"class_name" binding:"required"`
}

type DeleteAlertOverview struct {
	ClassId  int   `json:"class_id" form:"class_id"`
	ClassIds []int `json:"class_ids" form:"class_ids" binding:"required_without=ClassId"`
}

type MoveAlertOverview struct {
	ClassId   int    `json:"class_id" form:"class_id" binding:"required"`
	Direction string `json:"direction" form:"direction" binding:"oneof=up down"`
}

type DetailAlertOverview struct {
	OverviewTime string `json:"overview_time" form:"overview_time" binding:"omitempty,oneof=today week month year"`
	StartTime    string `json:"start_time" form:"start_time" binding:"omitempty,datetime=2006-01-02 15:04:05"`
	EndTime      string `json:"end_time" form:"end_time" binding:"omitempty,datetime=2006-01-02 15:04:05"`
}

type ListAlertOverview struct {
	ClassId   int    `json:"class_id" form:"class_id"`
	ClassName string `json:"class_name" form:"class_name"`
	Pagination
}
