package request

import (
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/entity"
)

type AddAlertRules struct {
	MetricName          string                    `json:"metric_name" form:"metric_name" binding:"required"`                                  // 预警规则名称(指标名称)
	DetectionType       int                       `json:"detection_type" form:"detection_type" binding:"oneof=1 2"`                           // 检测类型 1:静态阈值 2:自定义
	ClassId             int                       `json:"class_id" form:"class_id" binding:"required_if=DetectionType 1"`                     // 预警对象id(级联:预警分类/预警对象)
	ClassParentName     string                    `json:"class_parent_name" form:"class_parent_name" binding:"required_if=DetectionType 2"`   // 预警分类名称
	ClassName           string                    `json:"class_name" form:"class_name" binding:"required_if=DetectionType 2"`                 // 预警对象名称
	MetricConfigId      string                    `json:"metric_config_id" form:"'metric_config_id'" binding:"required_if=DetectionType 1"`   // 预警指标id
	MetricConfigName    string                    `json:"metric_config_name" form:"metric_config_name" binding:"required_if=DetectionType 2"` // 预警指标名称(映射entity.MetricConfig.MetricName)
	Expr                string                    `json:"expr" form:"expr" binding:"required_if=DetectionType 2"`                             // 指标表达式(PromQL语句)
	AlertCondition      []entity.AlertCondition   `json:"alert_condition" form:"alert_condition" binding:"required"`                          // 预警规则 字典值
	AlertRuleType       string                    `json:"alert_rule_type" form:"alert_rule_type" binding:"required_if=DetectionType 2"`       // 预警规则类型 关联字典表
	AlertRange          []entity.RulesAlertRange  `json:"alert_range" form:"alert_range"  binding:"required,dive"`                            // 预警范围 字典值
	Duration            int                       `json:"duration" form:"duration" binding:"gte=0"`                                           // 持续时间
	DurationUnit        string                    `json:"duration_unit" form:"duration_unit" binding:"oneof=s m h"`                           // 持续时间单位 s m h
	CheckPeriod         int                       `json:"check_period" form:"check_period" binding:"oneof=1 3 5 10 20 30"`                    // 检查周期 单位:分钟
	NotifyMethod        []string                  `json:"notify_method" form:"notify_method" binding:"max=2,dive,oneof=dingtalk sms"`         // 预警通知方式 dingtalk sms
	NotifyRecipients    []entity.NotifyRecipients `json:"notify_recipients" form:"notify_recipients" binding:"dive"`                          // 预警推送用户
	NotifyPushCount     int                       `json:"notify_push_count" form:"notify_push_count" binding:"gte=1"`                         // 消息推送次数
	NotifyPushFrequency int                       `json:"notify_push_frequency" form:"notify_push_frequency" binding:"gte=1"`                 // 消息推送频率 分钟
	IsEnabled           int                       `json:"is_enabled" form:"is_enabled" binding:"oneof=1 2"`                                   // 是否开启 1:是 2:否
}

type UpdateAlertRules struct {
	Id                  string                    `json:"id" form:"id" binding:"required"`
	MetricName          string                    `json:"metric_name" form:"metric_name" binding:"required"`                                  // 预警规则名称(指标名称)
	DetectionType       int                       `json:"detection_type" form:"detection_type" binding:"oneof=1 2"`                           // 检测类型 1:静态阈值 2:自定义
	ClassId             int                       `json:"class_id" form:"class_id" binding:"required_if=DetectionType 1"`                     // 预警对象id(级联:预警分类/预警对象)
	ClassParentName     string                    `json:"class_parent_name" form:"class_parent_name" binding:"required_if=DetectionType 2"`   // 预警分类名称
	ClassName           string                    `json:"class_name" form:"class_name" binding:"required_if=DetectionType 2"`                 // 预警对象名称
	MetricConfigId      string                    `json:"metric_config_id" form:"'metric_config_id'" binding:"required_if=DetectionType 1"`   // 预警指标id
	MetricConfigName    string                    `json:"metric_config_name" form:"metric_config_name" binding:"required_if=DetectionType 2"` // 预警指标名称(映射entity.MetricConfig.MetricName)
	Expr                string                    `json:"expr" form:"expr" binding:"required_if=DetectionType 2"`                             // 指标表达式(PromQL语句)
	AlertCondition      []entity.AlertCondition   `json:"alert_condition" form:"alert_condition" binding:"required"`                          // 预警规则 字典值
	AlertRuleType       string                    `json:"alert_rule_type" form:"alert_rule_type" binding:"required_if=DetectionType 2"`       // 预警规则类型 关联字典表
	AlertRange          []entity.RulesAlertRange  `json:"alert_range" form:"alert_range"  binding:"required,dive"`                            // 预警范围 字典值
	Duration            int                       `json:"duration" form:"duration" binding:"gte=0"`                                           // 持续时间
	DurationUnit        string                    `json:"duration_unit" form:"duration_unit" binding:"oneof=s m h"`                           // 持续时间单位 s m h
	CheckPeriod         int                       `json:"check_period" form:"check_period" binding:"oneof=1 3 5 10 20 30"`                    // 检查周期 单位:分钟
	NotifyMethod        []string                  `json:"notify_method" form:"notify_method" binding:"max=2,dive,oneof=dingtalk sms"`         // 预警通知方式 dingtalk sms
	NotifyRecipients    []entity.NotifyRecipients `json:"notify_recipients" form:"notify_recipients" binding:"dive"`                          // 预警推送用户
	NotifyPushCount     int                       `json:"notify_push_count" form:"notify_push_count" binding:"gte=1"`                         // 消息推送次数
	NotifyPushFrequency int                       `json:"notify_push_frequency" form:"notify_push_frequency" binding:"gte=1"`                 // 消息推送频率 分钟
	IsEnabled           int                       `json:"is_enabled" form:"is_enabled" binding:"oneof=1 2"`                                   // 是否开启 1:是 2:否
}

type UpdateIsEnabledAlertRules struct {
	Id        string `json:"id" form:"id" binding:"required"`
	IsEnabled int    `json:"is_enabled" form:"is_enabled" binding:"oneof=1 2"` // 是否开启 1:是 2:否
}

type DeleteAlertRules struct {
	Id  string   `json:"id" form:"id"`
	Ids []string `json:"ids" form:"ids" binding:"required_without=Id"`
}

type DetailAlertRules struct {
	Id string `json:"id" form:"id" binding:"required"`
}

type ListAlertRules struct {
	// 请输入预警规则名称/预警对象/预警分类/预警指标
	Id           string `json:"id" form:"id"`
	NotifyMethod string `json:"notify_method" form:"notify_method" binding:"omitempty,oneof=all dingtalk sms"` // 预警通知方式 dingtalk sms
	IsEnabled    int    `json:"is_enabled" form:"is_enabled" binding:"omitempty,oneof=1 2"`                    // 是否开启 1:是 2:否
	Keyword      string `json:"keyword" form:"keyword"`                                                        // 预警规则名称(指标名称)
	StartTime    string `json:"start_time" form:"start_time" binding:"omitempty,datetime=2006-01-02 15:04:05"`
	EndTime      string `json:"end_time" form:"end_time" binding:"omitempty,datetime=2006-01-02 15:04:05"`
	Pagination
}
