package request

import "gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"

type DictReq struct {
	Id       string `json:"id" form:"id"` //主键ID
	Status   int    `json:"status" form:"status"`
	Class    int    `json:"class" form:"class" binding:"oneof=0 1 2 3 4 5 6 7 8 9 10 11 12 13 14"` //组件分类(1开发语言与版本  2中间件类型与中间件  3云组件类型  4模块类型  5所属区域  6操作系统  7对象类型  8SQL类型  9调研评估结果  10任务阶段  11测试文档类型  12验收问题类型  13Q&A问题类型 14文档类型)
	ParentId string `json:"parent_id" form:"parent_id"`                                            //父级ID
	Search   string `json:"search" form:"search"`
	Pagination
}

type DictTreeReq struct {
	Class    int    `json:"class" form:"class" binding:"oneof=0 1 2 3 4 5 6 7 8 9 10 11 12 13 14"` //组件分类(1开发语言与版本  2中间件类型与中间件  3云组件类型  4模块类型  5所属区域  6操作系统  7对象类型  8SQL类型  9调研评估结果  10任务阶段  11测试文档类型  12验收问题类型  13Q&A问题类型 14文档类型)
	ParentId string `json:"parent_id" form:"parent_id"`                                            //父级ID
}

type AddDictReq struct {
	Class       int    `json:"class" form:"class" binding:"required,oneof=1 2 3 4 5 6 7 8 9 10 11 12 13 14"` //组件分类(1开发语言与版本  2中间件类型与中间件  3云组件类型  4模块类型  5所属区域  6操作系统  7对象类型  8SQL类型  9调研评估结果  10任务阶段  11测试文档类型  12验收问题类型  13Q&A问题类型 14文档类型)
	ParentId    string `json:"parent_id" form:"parent_id"`                                                   //父级ID
	Name        string `json:"name" form:"name" binding:"required"`                                          //字典标签
	Status      int    `json:"status" form:"status" binding:"oneof=0 1 2"`                                   //是否启用(1:启用 2:禁用)
	Description string `json:"description" form:"description" binding:"lte=200"`                             //描述
	MinVal      string `json:"min_val" form:"min_val"`                                                       //最大值
	MaxVal      string `json:"max_val" form:"max_val"`                                                       //最小值
	Unit        string `json:"unit" form:"unit"`                                                             //最小值
}

type UpdateDictReq struct {
	Id          string        `json:"id" form:"id" binding:"required"`                  //组件ID
	ParentId    string        `json:"parent_id" form:"parent_id"`                       //父级ID
	Name        string        `json:"name" form:"name" binding:"required"`              //字典标签
	Status      int           `json:"status" form:"status" binding:"oneof=0 1 2"`       //是否启用(1:启用 2:禁用)
	Description string        `json:"description" form:"description" binding:"lte=200"` //描述
	MinVal      string        `json:"min_val" form:"min_val"`                           //最大值
	MaxVal      string        `json:"max_val" form:"max_val"`                           //最小值
	Unit        string        `json:"unit" form:"unit"`                                 //最小值
	UpdatedBy   int           `json:"updated_by" `                                      //修改人
	UpdatedAt   jsontime.Time `json:"updated_at"`                                       //修改时间
}

type DictManageListReq struct {
	Id          string `json:"id" form:"id" binding:"required"`                  //组件ID
	ParentId    string `json:"parent_id" form:"parent_id"`                       //父级ID
	Name        string `json:"name" form:"name" binding:"required"`              //字典标签
	Status      int    `json:"status" form:"status" binding:"oneof=0 1 2"`       //是否启用(1:启用 2:禁用)
	Description string `json:"description" form:"description" binding:"lte=200"` //描述
	MinVal      string `json:"min_val" form:"min_val"`                           //最大值
	MaxVal      string `json:"max_val" form:"max_val"`                           //最小值
}

type DictSortInput struct {
	Id   string `json:"id"`   //id
	Sort int    `json:"sort"` //排序
}
