package request

import "time"

type UserReq struct {
	SystemAccount string `json:"system_account" vd:"len($)>0;msg:'请填写系统账号'"`
	Password      string `json:"password" vd:"len($)>0;msg:'请填写密码'"`
}

type UserOrgInfo struct {
	Id               int32     `json:"id" xorm:"pk autoincr" `                     //id
	OrganizationId   string    `json:"organization_id" xorm:"organization_id"`     //所属组织
	OrganizationName string    `json:"organization_name" xorm:"organization_name"` //所属组织id
	BusinessCode     string    `json:"business_code" xorm:"business_code"`         //业务系统编码
	BusinessName     string    `json:"business_name" xorm:"business_name"`         //业务系统名称
	SystemAccount    string    `json:"system_account" xorm:"system_account"`       //系统账号
	SystemRoleId     string    `json:"system_role_id" xorm:"system_role_id"`       //系统角色id
	Password         string    `json:"password"`                                   //密码
	AccessAddress    string    `json:"access_address" xorm:"access_address"`       //访问地址
	DevelopId        string    `json:"develop_id" xorm:"develop_id"`               //开发厂商uuid
	BusinessDesc     string    `json:"business_desc" xorm:"business_desc"`         //业务系统描述
	State            int       `json:"state" xorm:"state"`                         //状态0禁用1启用
	Logo             string    `json:"logo" xorm:"logo"`                           //头像logo
	ContactName      string    `json:"contact_name" xorm:"contact_name"`           //联系人姓名
	ContactPhone     string    `json:"contact_phone" xorm:"contact_phone"`         //联系人电话
	ContactEmail     string    `json:"contact_email" xorm:"contact_email"`         //联系人邮箱
	Remark           string    `json:"remark" xorm:"remark"`                       //备注
	CreatedBy        string    `json:"created_by"  `                               //创建者
	CreatedTime      time.Time `json:"created_time" xorm:"created" `               //创建时间
	UpdatedBy        string    `json:"updated_by"  `                               //更新者
	UpdatedTime      time.Time `json:"updated_time" xorm:"updated" `               //更新时间
	IsDeleted        int       `json:"is_deleted" xorm:"is_deleted"`               //是否删除
	SystemId         string    `json:"system_id" xorm:"system_id"`                 //系统账号id
	IsAdmin          int       `json:"is_admin" xorm:"is_admin"`                   //用户类型
}
