package request

type AddSystemAccessRuleReq struct {
	RuleName   string      `json:"ruleName" vd:"len($)>0;msg:'请输入规则名称'"`       // 规则名称
	State      int         `json:"state" vd:"$ == 0 || $ == 1;msg:'请选择正确的状态'"` // 状态0禁用1启用
	RuleType   int         `json:"ruleType" vd:"$ == 1;msg:'请选择正确的规则类型'"`      // 规则类型
	RuleDetail string      `json:"ruleDetail" vd:"len($)>0;msg:'请输入规则'"`       // 规则
	UserScope  []UserScope `json:"userScope"  vd:"len($)>0;msg:'请选择用户范围'"`     //用户范围
	CreatedBy  int         `json:"createdBy" `                                 //创建人
}

type UserScope struct {
	UserId int `json:"user_id"` // 系统账号id
}

type UpdateAccessRuleReq struct {
	RuleId     string      `json:"ruleId" vd:"len($)>0;msg:'请输入规则id'"`         // 规则ID
	RuleName   string      `json:"ruleName" vd:"len($)>0;msg:'请输入规则名称'"`       // 规则名称
	State      int         `json:"state" vd:"$ == 0 || $ == 1;msg:'请选择正确的状态'"` // 状态0禁用1启用
	RuleType   int         `json:"ruleType" vd:"$ == 1;msg:'请选择正确的规则类型'"`      // 规则类型
	RuleDetail string      `json:"ruleDetail" vd:"len($)>0;msg:'请输入规则'"`       // 规则
	UserScope  []UserScope `json:"userScope"  vd:"len($)>0;msg:'请选择用户范围'"`     //用户范围
	UpdatedBy  int         `json:"updatedBy" `                                 //修改人
}

type DelAccessRuleReq struct {
	RuleId []string `json:"ruleId" vd:"len($)>0;msg:'请输入规则id'"` // 规则ID
}

type ListAccessRuleReq struct {
	Search string `json:"search" form:"search"` // 关键词搜索
	Pagination
	UpdatedTimeFrom string `json:"updatedTimeFrom" form:"updatedTimeFrom"` // 修改时间从
	UpdatedTimeTo   string `json:"updatedTimeTo" form:"updatedTimeTo"`     // 修改时间至
}

type ListRuleUserReq struct {
	Search string `json:"search" form:"search"` // 关键词搜索
	Pagination
	Id int `json:"id" form:"id"` // 账号
	//IsAdmin int `json:"isAdmin" form:"isAdmin"` // 用户类型(1.业务系统账号 2.组织管理员账号 3.平台用户账号 4.超级管理员)
	//Name           string `json:"name" form:"name"`                     // 所属组织
	OrganizationId string `json:"organizationId" form:"organizationId"` // 组织ID
	Disp           int    `json:"disp" form:"disp"`                     // 展示维度（0：展示访问规则已选用户，1：展示所有用户）
}
