package request

// 添加组织入参
type OrgInput struct {
	POrganizationId  string `json:"p_organization_id"` //父级组织id或者目录id
	Name             string `json:"name"`              //组织名称or目录名称
	OrganizationCode string `json:"organization_code"` //组织机构代码
	Description      string `json:"description"`       //组织介绍
	DataType         int64  `json:"data_type"`         //数据类型(0目录 1组织)
}

// 组织排序参数
type OrgSortInput struct {
	Id   int64 `json:"id" xorm:"pk autoincr"` //id
	Sort int64 `json:"sort"`                  //排序
}

// 查询组织详情参数
type QueryOrgDetailInput struct {
	OrganizationId string `form:"organization_id"`    // 组织id
	State          string `form:"state" xorm:"state"` // 状态0禁用 1启用
	KeyWord        string `form:"key_word"`           // 关键字（账号或者手机号）
	Limit          int    `form:"limit"`              // 页条
	Page           int    `form:"page"`               // 页码
	DataType       string `form:"data_type"`          // 数据类型(0目录 1组织 2平台用户组织)
}

// 查询业务系统信息
type GetBusinessMsgInput struct {
	Limit          int    `form:"limit"`           // 页条
	Page           int    `form:"page"`            // 页码
	OrganizationId string `form:"organization_id"` // 所属组织
}

// 新增用户
type OrgUserInput struct {
	Name           string   `json:"name"`                                         // 姓名
	Logo           string   `json:"logo"`                                         // 头像logo
	SystemAccount  string   `json:"system_account"  vd:"len($)>1;msg:'请输入账号'"`    // 系统账号
	Phone          string   `json:"phone" vd:"phone($)"`                          // 联系人电话
	Password       string   `json:"password" vd:"len($)>1;msg:'请输入密码'"`           // 密码
	SelectRole     []string `json:"select_role"`                                  // 选择角色
	State          int      `json:"state"`                                        // 状态0禁用1启用
	OrganizationId string   `json:"organization_id"  vd:"len($)>1;msg:'请选择所属组织'"` // 所属组织
	//IsAdmin        int      `json:"is_admin"`                                     // 用户类型(1.业务系统账号 2.组织管理员账号 3.平台用户账号)
}

// 编辑用户
type UpdateOrgUserInput struct {
	Name          string   `json:"name"`                                      // 联系人姓名
	Logo          string   `json:"logo"`                                      // 头像logo
	SystemAccount string   `json:"system_account"  vd:"len($)>1;msg:'请输入账号'"` // 系统账号
	Phone         string   `json:"phone" vd:"phone($)"`                       // 联系人电话
	SelectRole    []string `json:"select_role"`                               // 选择角色
	State         int      `json:"state"`                                     // 状态0禁用1启用

}

// 删除用户
type DelOrgUser struct {
	Ids []int `json:"ids" xorm:"pk autoincr"` //id
}

// 去重校验
type CheckRepetition struct {
	Id    int    `form:"id" json:"id"`
	Phone string `form:"phone" json:"phone"`
}
