package request

type CreateSystemRoleReq struct {
	RoleName string `json:"role_name"  vd:"len($)>0;msg:'请输入角色名称'"` // 角色名称
	RoleDesc string `json:"role_desc"`                              // 角色描述
	State    int    `json:"state"`                                  // 状态0禁用1启用
	RoleId   string `json:"role_id"`                                // 角色id（uuid）
	//DataPurview int    `json:"data_purview" vd:"$>0;msg:'请输入数据权限'"`    // 数据权限：1-仅自己，2-本组织所有，3-全平台所有
	MenuIds   []int `json:"menu_ids"  ` // 菜单ids
	CreatedBy int   `json:"created_by"` // 用户创建人
}

type UpdateSystemRoleReq struct {
	Id       int    `json:"id"`                                     // id
	RoleName string `json:"role_name"  vd:"len($)>0;msg:'请输入角色名称'"` // 角色名称
	RoleDesc string `json:"role_desc"`                              // 角色描述
	State    int    `json:"state"`                                  // 状态0禁用1启用
	//DataPurview int    `json:"data_purview" vd:"$>0;msg:'请输入数据权限'"`    // 数据权限：1-仅自己，2-本组织所有，3-全平台所有
	MenuIds   []int `json:"menu_ids"  ` // 菜单ids
	UpdatedBy int   `json:"updated_by"` // 角色更新人
}

type SystemRoleListReq struct {
	IsAdmin int    `json:"is_admin"`
	Search  string `json:"search" form:"search"`
	Pagination
}
type SystemAllotUserListReq struct {
	Pagination
	Search         string `json:"search" form:"search"`
	RoleId         int    `json:"role_id" form:"role_id" vd:"$>0;msg:'请输入role_id'"` // 角色id
	IsAdmin        int    `json:"is_admin" form:"is_admin"`                         // 账户类型
	OrganizationId int64  `json:"organization_id" form:"organization_id"`           // 所属组织
}
type SystemRoleDetailReq struct {
	Id string `json:"id" form:"id" vd:"len($)>0;msg:'请输入id'"` // id
}
type SystemRoleStateReq struct {
	Id    string `json:"id" form:"id" vd:"len($)>0;msg:'请输入id'"` // id
	State string `json:"state" vd:"len($)>0;msg:'请填写状态'"`        // Id
}

type DeleteSystemRoleReq struct {
	Ids []int `json:"ids"` // ids
}
type SystemRoleAllotmentUserReq struct {
	UserIds []int `json:"user_ids"` // 用户ids
	Id      int   `json:"id"`       // id
}
