package request

type CreateSystemUserReq struct {
	OrganizationId string `json:"organization_id"  vd:"len($)>1;msg:'请选择所属组织'"` // 所属组织
	BusinessName   string `json:"business_name" vd:"len($)>1;msg:'请输入业务系统名称'"`  // 业务系统名称
	SystemAccount  string `json:"system_account"  vd:"len($)>1;msg:'请输入账号'"`    // 系统账号
	Password       string `json:"password" vd:"len($)>1;msg:'请输入密码'"`           // 密码
	SystemRoleId   string `json:"system_role_id"`
	AccessAddress  string `json:"access_address"` // 访问地址
	DevelopId      string `json:"develop_id"`     // 开发厂商uuid
	BusinessDesc   string `json:"business_desc"`  // 业务系统描述
	State          int    `json:"state"`          // 状态0禁用1启用
	Logo           string `json:"logo"`           // 头像logo
	ContactName    string `json:"contact_name"`   // 联系人姓名
	ContactPhone   string `json:"contact_phone"`  // 联系人电话
	ContactEmail   string `json:"contact_email"`  // 联系人邮箱
	Remark         string `json:"remark"`         // 备注
	CreatedBy      string `json:"created_by"`     // 用户创建人
	UpdatedBy      string `json:"updated_by"`     // 用户更新人
	IsAdmin        int    `json:"is_admin"`       // 用户类型
}

type UpdateSystemUserReq struct {
	Id            int    `json:"id" form:"id" vd:"$>0;msg:'请输入id'"`           // id
	BusinessName  string `json:"business_name" vd:"len($)>1;msg:'请输入业务系统名称'"` // 业务系统名称
	SystemAccount string `json:"system_account"  vd:"len($)>1;msg:'请输入账号'"`   // 系统账号
	AccessAddress string `json:"access_address"`                              // 访问地址
	DevelopId     string `json:"develop_id"`                                  // 开发厂商uuid
	BusinessDesc  string `json:"business_desc"`                               // 业务系统描述
	State         int    `json:"state"`                                       // 状态0禁用1启用
	Logo          string `json:"logo"`                                        // 头像logo
	ContactName   string `json:"contact_name"`                                // 联系人姓名
	ContactPhone  string `json:"contact_phone"`                               // 联系人电话
	ContactEmail  string `json:"contact_email"`                               // 联系人邮箱
	Remark        string `json:"remark"`                                      // 备注
	UpdatedBy     string `json:"updated_by"`                                  // 用户更新人
}
type SystemUserListReq struct {
	Pagination
	OrganizationId int64 `json:"organization_id" form:"organization_id"` // 所属组织
}
type SystemUserDetailReq struct {
	Id string `json:"id" form:"id" vd:"len($)>0;msg:'请输入id'"` // id
}
type SystemUserStateReq struct {
	Id    int `json:"id" form:"id" vd:"len($)>0;msg:'请输入id'"` // id
	State int `json:"state" vd:"len($)>0;msg:'请填写状态'"`        // Id
}
type SystemUserEditPasswordReq struct {
	Id       int    `json:"id" form:"id" vd:"$>0;msg:'请输入id'"` // id
	Password string `json:"password"`                          // 密码
}
type DeleteSystemUserReq struct {
	Ids []int `json:"ids" form:"ids" vd:"len($)>0;msg:'请输入id'"` // ids
}
type ResetSystemUserPasswordReq struct {
	Ids []int `json:"ids" form:"ids" vd:"len($)>0;msg:'请输入id'"` // ids

}
type ResetSecretReq struct {
	Id int `json:"id" form:"id" vd:"$>0;msg:'请输入id'"` // ids
}
type CheckBusinessNameReq struct {
	Id             int    `json:"id" form:"id" `                                // id
	OrganizationId string `json:"organization_id"  vd:"len($)>1;msg:'请选择所属组织'"` // 所属组织
	BusinessName   string `json:"business_name" vd:"len($)>1;msg:'请输入业务系统名称'"`  // 业务系统名称
}
type CheckAccountReq struct {
	Id            int    `json:"id" form:"id" `                             // id
	SystemAccount string `json:"system_account"  vd:"len($)>1;msg:'请输入账号'"` // 系统账号
}
