package request

type AddTaskManageReq struct {
	TaskName    string `json:"task_name" vd:"len($)>0;msg:'请输入任务名称'"` // 任务名称
	TaskDesc    string `json:"task_desc"`                             // 任务描述
	YamlDesc    string `json:"yaml_desc"`                             // yaml内容
	YamlUrl     string `json:"yaml_url"`                              // yaml文件url
	HostGroupId int    `json:"host_group_id" vd:"$>0;msg:'请选择主机分组'"`  // 主机分组ID
}

type EditTaskManageReq struct {
	Id          int    `json:"id" vd:"$>0;msg:'请输入id'"`              // 主键ID
	TaskDesc    string `json:"task_desc"`                            // 任务描述
	YamlDesc    string `json:"yaml_desc"`                            // yaml内容
	YamlUrl     string `json:"yaml_url"`                             // yaml文件url
	HostGroupId int    `json:"host_group_id" vd:"$>0;msg:'请选择主机分组'"` // 主机分组ID
}

type DelTaskManageReq struct {
	Id []int `json:"id" vd:"len($)>0;msg:'请输入id'"` // 主键ID
}

type DetailsTaskManageReq struct {
	Id int `json:"id" vd:"$>0;msg:'请输入id'"` // 主键ID
}

type ListTaskManageReq struct {
	Search         string `json:"search" form:"search"`                     //关键词
	CreateDateFrom string `json:"create_date_from" form:"create_date_from"` //创建时间从
	CreateDateTo   string `json:"create_date_to" form:"create_date_to"`     //创建时间至
	HostGroupId    int    `json:"host_group_id" form:"host_group_id"`       //主机分组ID
	Pagination
}

type ExecScriptReq struct {
	HostGroupId int    `form:"host_group_id" vd:"$>0;msg:'请输入主机分组id'"` //主机分组id
	Type        int    `form:"type"`                                   //脚本额外变量类型1yaml 2json
	Value       string `form:"value"`                                  //脚本额外变量值
	Script      string `form:"script"`                                 //执行脚本
	ScriptUrl   string `form:"script_url"`                             //执行脚本url
}
