package request

type AddWorkOrderReq struct {
	IsPush       int            `json:"is_push"`                           // 是否立刻下发(0否 1是)
	OrderName    string         `json:"order_name" binding:"required"`     // 工单名称
	OrderLevel   int            `json:"order_level" binding:"oneof=1 2 3"` // 工单等级(1紧急任务 2重要任务 3一般任务)
	OrderDesc    string         `json:"order_desc" binding:"required"`     // 工单描述
	PushObj      PushObj        `json:"push_obj" binding:"required,dive"`  // 推送对象
	TimingType   int            `json:"timing_type" binding:"oneof=1 2 3"` // 定时类型(1手动下发 2按周 3自定义时间)
	TimingWeekly TimingWeekly   `json:"timing_weekly"`                     // 按周规则
	TimingCustom []TimingCustom `json:"timing_custom"`                     // 自定义时间规则
}

// 推送对象
type PushObj struct {
	PushMethod int       `json:"push_method" binding:"oneof=1 2 3"` // 推送方式(1钉钉 2短信 3all)
	UserObj    []UserObj `json:"user_obj" binding:"dive"`           // 用户对象
}
type UserObj struct {
	SystemAccount string `json:"system_account" binding:"required"` // 账号
	UserName      string `json:"user_name"`                         // 姓名
	Phone         string `json:"phone"`                             // 联系方式
}

// 按周
type TimingWeekly struct {
	Week      []int  `json:"week"`       // 周日期(1周一 2周二 3周三 4周四 5周五 6周六 7周日)
	PointTime string `json:"point_time"` // 时间点
}

// 自定义
type TimingCustom struct {
	DateFrom  string `json:"date_from"`  // 日期从
	DateTo    string `json:"date_to"`    // 日期至
	PointTime string `json:"point_time"` // 时间点
}

type EditWorkOrderReq struct {
	IsPush       int            `json:"is_push" binding:"required"`        // 是否立刻下发(0否 1是)
	Id           int            `json:"id" binding:"required"`             // 主键id
	OrderLevel   int            `json:"order_level" binding:"oneof=1 2 3"` // 工单等级(1紧急任务 2重要任务 3一般任务)
	OrderDesc    string         `json:"order_desc" binding:"required"`     // 工单描述
	PushObj      PushObj        `json:"push_obj" binding:"required,dive"`  // 推送对象
	TimingType   int            `json:"timing_type" binding:"oneof=1 2 3"` // 定时类型(1手动下发 2按周 3自定义时间)
	TimingWeekly TimingWeekly   `json:"timing_weekly"`                     // 按周规则
	TimingCustom []TimingCustom `json:"timing_custom"`                     // 自定义时间规则
}

type StateWorkOrderReq struct {
	Id          int `json:"id" binding:"required"`            // 主键id
	TimingState int `json:"timing_state" binding:"oneof=0 1"` // 定时状态（0禁用 1启用）
}

type DelWorkOrderReq struct {
	Id []int `json:"id" binding:"required"` // 主键ID
}

type ListWorkOrderManageReq struct {
	Search         string `json:"search" form:"search"`                                   //关键词
	OrderLevel     int    `json:"order_level" form:"order_level" binding:"oneof=0 1 2 3"` //工单等级(0全部 1紧急任务 2重要任务 3一般任务)
	TimingType     int    `json:"timing_type" form:"timing_type" binding:"oneof=0 1 2 3"` //定时类型(0全部 1手动下发 2按周 3自定义时间)
	CreateDateFrom string `json:"create_date_from"  form:"create_date_from" `             // 创建时间从
	CreateDateTo   string `json:"create_date_to" form:"create_date_to" `                  // 创建时间至
	Pagination
}

type PushWorkOrderReq struct {
	Id      int     `json:"id" binding:"required"`            // 主键id
	PushObj PushObj `json:"push_obj" binding:"required,dive"` // 推送对象
}

type CloseWorkOrderReq struct {
	Id            int    `json:"id" binding:"required"`             // 主键id
	ReasonClosure string `json:"reason_closure" binding:"required"` // 关闭原因
}

type ListWorkOrderReq struct {
	Search           string `json:"search" form:"search"`                                   //关键词
	OrderLevel       int    `json:"order_level" form:"order_level" binding:"oneof=0 1 2 3"` //工单等级(0全部 1紧急任务 2重要任务 3一般任务)
	OrderState       int    `json:"order_state" form:"order_state" binding:"oneof=0 1 2 3"` //工单状态(0全部 1待处置 2已完成 3已关闭)
	CreateDateFrom   string `json:"create_date_from"  form:"create_date_from" `             // 创建时间从
	CreateDateTo     string `json:"create_date_to" form:"create_date_to" `                  // 创建时间至
	CompleteTimeFrom string `json:"complete_time_from"  form:"complete_time_from" `         // 完成时间从
	CompleteTimeTo   string `json:"complete_time_to" form:"complete_time_to" `              // 完成时间至
	Id               int    `json:"id" form:"id" `                                          // 工单管理主键id
	Pagination
}

type FeedbackWorkOrderReq struct {
	Id              int    `json:"id" binding:"required"`                // 主键id
	OrderIssuanceId int    `json:"order_issuance_id" binding:"required"` // 下发工单表id
	ResultFeedback  string `json:"result_feedback" binding:"required"`   // 结果反馈
}
