package response

import "time"

type TaskManageListRes struct {
	Id         int       `json:"id" xorm:"pk autoincr" `          // id
	TaskName   string    `json:"task_name" xorm:"task_name"`      // 任务名称
	TaskDesc   string    `json:"task_desc" xorm:"task_desc"`      // 任务描述
	ExecCnt    int       `json:"exec_cnt" xorm:"exec_cnt"`        // 执行次数
	CreateUser string    `json:"create_user" xorm:"create_user" ` // 创建人
	CreateTime time.Time `json:"create_time"  xorm:"create_time"` // 创建时间
}

type TaskManageRes struct {
	Id          int        `json:"id"`                     // id
	HostGroupId int        `json:"host_group_id"`          // 主机分组id
	TaskName    string     `json:"task_name"`              // 任务名称
	TaskDesc    string     `json:"task_desc"`              // 任务描述
	YamlDesc    string     `json:"yaml_desc"`              // yaml文件
	YamlUrl     string     `json:"yaml_url"`               // yaml文件地址
	ExecCnt     int        `json:"exec_cnt"`               // 执行次数
	SuccessCnt  int        `json:"success_cnt"`            // 执行成功次数
	FailCnt     int        `json:"fail_cnt"`               // 执行失败次数
	HostList    []HostList `json:"host_list" xorm:"-"`     // 主机列表
	HostFileUrl string     `json:"host_file_url" xorm:"-"` // 主机文件url
	CreateUser  string     `json:"create_user"`            // 创建人
	CreateTime  time.Time  `json:"create_time"`            // 创建时间
}
