package response

import (
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"time"
)

type WorkOrderRes struct {
	Id          int             `json:"id"`           // 主键id
	OrderName   string          `json:"order_name"`   // 工单名称
	OrderLevel  int             `json:"order_level"`  // 工单等级(1紧急任务 2重要任务 3一般任务)
	OrderDesc   string          `json:"order_desc"`   // 工单描述
	PushObj     request.PushObj `json:"push_obj" `    // 推送对象
	TimingState int             `json:"timing_state"` // 定时状态（0禁用 1启用）
	TimingType  int             `json:"timing_type"`  // 定时类型(1手动下发 2按周 3自定义时间)
	TimingRule  interface{}     `json:"timing_rule"`  // 定时规则
	CreateUser  string          `json:"create_user"`  // 创建人
	CreateTime  time.Time       `json:"create_time"`  // 创建时间
	UpdateUser  string          `json:"update_user"`  // 修改人
	UpdateTime  time.Time       `json:"update_time"`  // 修改时间
}

type WorkOrderListRes struct {
	Id          int       `json:"id"`           // 主键id
	OrderName   string    `json:"order_name"`   // 工单名称
	OrderLevel  int       `json:"order_level"`  // 工单等级(1紧急任务 2重要任务 3一般任务)
	OrderCnt    int       `json:"order_cnt"`    // 实例工单数
	PushObj     string    `json:"push_obj" `    // 推送对象
	TimingType  int       `json:"timing_type"`  // 定时类型(1手动下发 2按周 3自定义时间)
	TimingState int       `json:"timing_state"` // 定时状态（0禁用 1启用）
	CreateUser  string    `json:"create_user"`  // 创建人
	CreateTime  time.Time `json:"create_time"`  // 创建时间
}

type WorkOrderIssuanceListRes struct {
	Id           int    `json:"id"`            // 主键id
	OrderId      int    `json:"order_id"`      // 工单id
	OrderName    string `json:"order_name"`    // 工单名称
	OrderLevel   int    `json:"order_level"`   // 工单等级(1紧急任务 2重要任务 3一般任务)
	OrderState   int    `json:"order_state"`   // 工单状态(1待处置 2已完成 3已关闭)
	PushObj      string `json:"push_obj" `     // 推送对象
	CreateUser   string `json:"create_user"`   // 创建人
	CreateTime   string `json:"create_time"`   // 创建时间
	CompleteTime string `json:"complete_time"` // 完成时间
	StateCnt     int    `json:"state_cnt"`     // 完成数量
	AllCnt       int    `json:"all_cnt"`       // 全部数量
}

type WorkOrderIssuanceRes struct {
	Id           int             `json:"id"`            // 主键id
	OrderId      int             `json:"order_id"`      // 工单id
	OrderName    string          `json:"order_name"`    // 工单名称
	OrderLevel   int             `json:"order_level"`   // 工单等级(1紧急任务 2重要任务 3一般任务)
	OrderDesc    string          `json:"order_desc"`    // 工单描述
	OrderState   int             `json:"order_state"`   // 工单状态(1待处置 2已完成 3已关闭)
	PushObj      request.PushObj `json:"push_obj" `     // 推送对象
	CreateUser   string          `json:"create_user"`   // 创建人
	CreateTime   string          `json:"create_time"`   // 创建时间
	CompleteTime string          `json:"complete_time"` // 完成时间
	WorkOrderMe  []WorkOrderMe   `json:"work_order_me"` // 工单反馈
}

type WorkOrderIssuance struct {
	Id           int    `json:"id"`            // 主键id
	OrderId      int    `json:"order_id"`      // 工单id
	OrderName    string `json:"order_name"`    // 工单名称
	OrderLevel   int    `json:"order_level"`   // 工单等级(1紧急任务 2重要任务 3一般任务)
	OrderDesc    string `json:"order_desc"`    // 工单描述
	OrderState   int    `json:"order_state"`   // 工单状态(1待处置 2已完成 3已关闭)
	PushObj      string `json:"push_obj" `     // 推送对象
	CreateUser   string `json:"create_user"`   // 创建人
	CreateTime   string `json:"create_time"`   // 创建时间
	CompleteTime string `json:"complete_time"` // 完成时间
}

type WorkOrderMe struct {
	Id              int    `json:"id"`                // id
	OrderId         int    `json:"order_id"`          // 工单id
	OrderIssuanceId int    `json:"order_issuance_id"` // 工单下发表id
	SystemAccount   string `json:"system_account"`    // 用户账号
	OrderState      int    `json:"order_state"`       // 工单状态(1待处置 2已完成 3已关闭)
	CompleteTime    string `json:"complete_time"`     // 完成时间
	ResultFeedback  string `json:"result_feedback"`   // 结果反馈
}

type WorkOrderMeListRes struct {
	Id              int    `json:"id"`                // 主键id
	OrderId         int    `json:"order_id"`          // 工单id
	OrderIssuanceId int    `json:"order_issuance_id"` // 工单下发表id
	OrderName       string `json:"order_name"`        // 工单名称
	OrderLevel      int    `json:"order_level"`       // 工单等级(1紧急任务 2重要任务 3一般任务)
	OrderState      int    `json:"order_state"`       // 工单状态(1待处置 2已完成 3已关闭)
	PushObj         string `json:"push_obj" `         // 推送对象
	CreateUser      string `json:"create_user"`       // 创建人
	CreateTime      string `json:"create_time"`       // 创建时间
	CompleteTime    string `json:"complete_time"`     // 完成时间
}
