package tools

import (
	"bufio"
	"fmt"
	"os"
	"strings"
)

func HostsToJson() (data map[string][]string, err error) {
	f, err := os.Open(`/etc/ansible/hosts`)
	//f, err := os.Open(`D:\work\goWork\智能运维平台\so-operation-api\src\common\tools\hosts`)

	if err != nil {
		return nil, err
	}
	defer f.Close()
	data = make(map[string][]string)
	// 以这个文件为参数，创建一个 scanner
	s := bufio.NewScanner(f)
	var key string
	var per []string
	// 扫描每行文件，按行读取
	for s.Scan() {
		if strings.HasPrefix(s.Text(), "[") && strings.HasSuffix(s.Text(), "]") {
			key = s.Text()
			per = []string{}
			data[key] = per
		} else {
			data[key] = append(data[key], s.Text())
		}
	}
	if s.Err() != nil {
		return nil, s.Err()
	}
	return data, nil
}

func MapToSaveHosts(data map[string][]string) error {
	f, err := os.OpenFile("/etc/ansible/hosts", os.O_APPEND|os.O_CREATE|os.O_RDWR|os.O_TRUNC, 0777)
	//f, err := os.OpenFile("D:/work/goWork/智能运维平台/so-operation-api/src/common/tools/hosts", os.O_APPEND|os.O_CREATE|os.O_RDWR|os.O_TRUNC, 0777)

	if err != nil {
		return err
	}
	defer f.Close()
	for k, v := range data {
		_, err = f.Write([]byte(fmt.Sprintf("%s\n", k)))
		if err != nil {
			return err
		}
		_, err = f.Write([]byte(strings.Join(v, "\n")))
		if err != nil {
			return err
		}
		_, err = f.Write([]byte("\n"))
		if err != nil {
			return err
		}
	}
	return nil
}
