package tools

import (
	"github.com/mojocn/base64Captcha"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/client"

	"log"
	"time"
)

type ConfigJsonBody struct {
	Id            string                       `json:"id"`
	CaptchaType   string                       `json:"captcha_type"`
	VerifyValue   string                       `json:"verify_value"`
	DriverAudio   *base64Captcha.DriverAudio   `json:"driver_audio"`
	DriverString  *base64Captcha.DriverString  `json:"driver_string"`
	DriverChinese *base64Captcha.DriverChinese `json:"driver_chinese"`
	DriverMath    *base64Captcha.DriverMath    `json:"driver_math"`
	DriverDigit   *base64Captcha.DriverDigit   `json:"driver_digit"`
}

type RedisStore struct {
}

var store = RedisStore{}

func GenerateCaptcha(param ConfigJsonBody) (id, b64s string, err error) {
	var driver base64Captcha.Driver
	switch param.CaptchaType {
	case "audio":
		driver = param.DriverAudio
	case "string":
		driver = param.DriverString.ConvertFonts()
	case "math":
		driver = param.DriverMath.ConvertFonts()
	case "chinese":
		driver = param.DriverChinese.ConvertFonts()
	default:
		driver = param.DriverDigit
	}
	c := base64Captcha.NewCaptcha(driver, store)
	id, b64s, err = c.Generate()
	//fmt.Println(id, b64s,err)
	//fmt.Println("base64编码1", b64s)
	//aaaa := b64s[strings.IndexByte(b64s, ',')+1:]
	//fmt.Println("base64编码2", aaaa)
	//ddd, err1 := base64.StdEncoding.DecodeString(aaaa) //成图片文件并把文件写入到buffer
	//fmt.Println("二进制", ddd)
	//fmt.Println("错误", err1)
	//err2 := ioutil.WriteFile("./output.png", ddd, 0666)   //buffer输出到jpg文件中（不做处理，直接写到文件）
	//fmt.Println(err2)
	return
}

func Verify(body ConfigJsonBody) bool {
	return store.Verify(body.Id, body.VerifyValue, true)

}

func (body RedisStore) Set(id string, value string) error {
	redis, err := client.GetRedisClient()
	if err != nil {
		log.Println(err)
	}
	return redis.Set(id, value, time.Hour*5)
}

func (body RedisStore) Get(id string, clear bool) string {
	redis, err := client.GetRedisClient()
	if err != nil {
		log.Println(err)
	}
	value, _ := redis.Get(id)
	return value
}

func (body RedisStore) Verify(id, answer string, clear bool) bool {
	redis, err := client.GetRedisClient()
	if err != nil {
		log.Println(err)
	}
	value, _ := redis.Get(id)
	right := false
	if answer == value {
		right = true
	} else {
		right = false
		return right
	}
	if clear {
		redis.Del(id)
	}
	return right
}
