package controller

import (
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/client"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
)

func UpdateAlertList(c *gin.Context) {
	var req request.UpdateAlertList
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.AlertListSvc{User: header.GetUser(c)}
	db, err := client.GetDbClient()
	if err != nil {
		SendJsonResponse(c, resp.DbConnectError.WithError(err), nil)
		return
	}
	err = svc.Update(db.NewSession(), req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func BatchPushAlertList(c *gin.Context) {
	var req request.BatchPushAlertList
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.AlertListSvc{User: header.GetUser(c)}
	db, err := client.GetDbClient()
	if err != nil {
		SendJsonResponse(c, resp.DbConnectError.WithError(err), nil)
		return
	}
	err = svc.BatchPushAlertList(db.NewSession(), req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func BatchCloseAlertList(c *gin.Context) {
	var req request.BatchCloseAlertList
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.AlertListSvc{User: header.GetUser(c)}
	db, err := client.GetDbClient()
	if err != nil {
		SendJsonResponse(c, resp.DbConnectError.WithError(err), nil)
		return
	}
	err = svc.BatchCloseAlertList(db.NewSession(), req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func DetailAlertList(c *gin.Context) {
	var req request.DetailAlertList
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.AlertListSvc{User: header.GetUser(c)}
	data, err := svc.GetDataById(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}

func ListAlertList(c *gin.Context) {
	var req request.ListAlertList
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}
	svc := service.AlertListSvc{User: header.GetUser(c)}
	data, err := svc.List(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}
