package controller

import (
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/client"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
)

// AddAlertOverview 新增任务
func AddAlertOverview(c *gin.Context) {
	var req request.AddAlertOverview
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.AlertOverviewSvc{User: header.GetUser(c)}
	db, err := client.GetDbClient()
	if err != nil {
		SendJsonResponse(c, resp.DbConnectError.WithError(err), nil)
		return
	}
	_, err = svc.Add(db.NewSession(), req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func UpdateAlertOverview(c *gin.Context) {
	var req request.UpdateAlertOverview
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.AlertOverviewSvc{User: header.GetUser(c)}
	db, err := client.GetDbClient()
	if err != nil {
		SendJsonResponse(c, resp.DbConnectError.WithError(err), nil)
		return
	}
	err = svc.Update(db.NewSession(), req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func DetailAlertOverview(c *gin.Context) {
	var req request.DetailAlertOverview
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.AlertOverviewSvc{User: header.GetUser(c)}
	data, err := svc.Overview(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}

func ListAlertOverview(c *gin.Context) {
	var req request.ListAlertOverview
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}
	svc := service.AlertOverviewSvc{User: header.GetUser(c)}
	data, err := svc.List(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}

func DeleteAlertOverview(c *gin.Context) {
	var req request.DeleteAlertOverview
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}
	var ids []int
	switch len(req.ClassIds) {
	case 0:
		ids = append(ids, req.ClassId)
	default:
		ids = req.ClassIds
	}

	svc := service.AlertOverviewSvc{User: header.GetUser(c)}
	err := svc.Delete(ids)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}
