package controller

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
	"strings"
)

// 系统日志树
func GetSystemLoggerList(c *gin.Context) {
	search := c.Query("logTime")
	svc := service.LogManagement{User: header.GetUser(c)}
	if dir, err := svc.GetSysLogDir(search); err != nil {
		SendJsonResponse(c, err, "")
	} else {
		SendJsonResponse(c, resp.OK, dir)
	}
}

// 系统日志
func GetSystemLog(c *gin.Context) {
	name := c.Query("name")
	search := c.Query("search")
	logLevel := c.Query("logLevel")
	svc := service.LogManagement{User: header.GetUser(c)}
	if logs, err := svc.GetSysLog(logLevel, search, name); err != nil {
		SendJsonResponse(c, err, "")
	} else {
		SendJsonResponse(c, resp.OK, logs)
	}
}

// 用户行为审计列表
func LogUserBehaviorList(c *gin.Context) {
	params := request.LogUserBehaviorListReq{}
	// 绑定分页数据
	if err := c.ShouldBindQuery(&params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	svc := service.LogManagement{User: header.GetUser(c)}
	var (
		list  interface{}
		count int64
		err   error
	)

	list, count, err = svc.LogUserBehaviorList(&params)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return

	}
	SendJsonPageResponse(c, nil, list, count)
}

// 用户行为审计列表导出
func LogUserBehaviorListExport(c *gin.Context) {
	params := request.LogUserBehaviorListReq{}
	// 绑定分页数据
	if err := c.ShouldBindQuery(&params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}
	// 分页数据初始化 limit page  Offset

	svc := service.LogManagement{User: header.GetUser(c)}
	file, fileName, err := svc.LogUserBehaviorListExport(&params)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	c.Writer.Header().Add("Content-Disposition", fmt.Sprintf("attachment; filename=%s", fileName)) //fmt.Sprintf("attachment; filename=%s", filename)对下载的文件重命名
	c.Writer.Header().Add("Content-Type", "application/octet-stream")
	c.Writer.Header().Add("Content-Transfer-Encoding", "binary")
	_ = file.Write(c.Writer)
}

func LogUserBehaviorDetail(c *gin.Context) {
	id := c.Param("id")
	if id == "" {
		SendJsonResponse(c, resp.InvalidParam.WithData("id必填"), nil)
		return
	}
	svc := service.LogManagement{User: header.GetUser(c)}
	data, err := svc.LogUserBehaviorDetail(id)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, nil, data)
}

func LogUserBehaviorDelete(c *gin.Context) {
	ids := strings.Split(c.Query("ids"), ",")
	if len(ids) == 0 {
		SendJsonResponse(c, resp.InvalidParam.WithData("id必填"), nil)
		return
	}
	svc := service.LogManagement{User: header.GetUser(c)}
	err := svc.LogUserBehaviorDelete(ids)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, nil, "删除成功")
}

//用户账户审计列表
//func LogUserAccountAuditList(c *gin.Context) {
//	params := request.LogManagementListReq{}
//	// 绑定分页数据
//	if err := c.ShouldBindQuery(&params); err != nil {
//		SendJsonResponse(c, res.ParamsParserError.ErrorDetail(err), nil)
//		return
//	}
//	// 分页数据初始化 limit page  Offset
//	params.PageInfo = params.PageInfo.InitPage()
//	svc := service.LogManagement{User: util.GetContextUser(c)}
//	list, count, err := svc.LogUserAccountAuditList(&params)
//	if err != nil {
//		SendJsonResponse(c, err, nil)
//		return
//	}
//	SendJsonPageResponse(c, err, list, count)
//}
//
//// 用户账户审计列表导出LogUserAccountAuditExport
//func LogUserAccountAuditExport(c *gin.Context) {
//	params := request.LogManagementListReq{}
//	// 绑定分页数据
//	if err := c.ShouldBindQuery(&params); err != nil {
//		SendJsonResponse(c, res.ParamsParserError.ErrorDetail(err), nil)
//		return
//	}
//	// 分页数据初始化 limit page  Offset
//	params.PageInfo = params.PageInfo.InitPage()
//	svc := service.LogManagement{User: util.GetContextUser(c)}
//	file, fileName, err := svc.LogUserAccountAuditExport(&params)
//	if err != nil {
//		SendJsonResponse(c, err, nil)
//		return
//	}
//	c.Writer.Header().Add("Content-Disposition", fmt.Sprintf("attachment; filename=%s", fileName)) //fmt.Sprintf("attachment; filename=%s", filename)对下载的文件重命名
//	c.Writer.Header().Add("Content-Type", "application/octet-stream")
//	c.Writer.Header().Add("Content-Transfer-Encoding", "binary")
//	_ = file.Write(c.Writer)
//
//}
