package controller

import (
	"errors"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"

	"github.com/gin-gonic/gin"
	"github.com/spf13/cast"
)

// 新增组织
func AddOrg(c *gin.Context) {
	var input request.OrgInput
	if err := c.ShouldBindJSON(&input); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}
	//参数检测 DataType 0 目录 1组织
	if input.DataType == 0 && input.Name == "" {
		SendJsonResponse(c, resp.InvalidParam.WithMsg("请输入目录名称"), nil)
		return
	}
	if input.DataType == 1 {
		if input.Name == "" {
			SendJsonResponse(c, resp.InvalidParam.WithError(errors.New("请输入机构名称")), nil)
			return
		}
		if input.OrganizationCode == "" {
			SendJsonResponse(c, resp.InvalidParam.WithMsg("请输入组织机构代码"), nil)
			return
		}
	}
	orgService := service.Organization{User: header.GetUser(c)}
	result, err := orgService.AddOrg(input)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, result)
}

// 更新组织或目录
func UpdateOrg(c *gin.Context) {
	var input request.OrgInput
	if err := c.ShouldBindJSON(&input); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}
	//参数检测 DataType 0 目录 1组织
	if input.DataType == 0 && input.Name == "" {
		SendJsonResponse(c, resp.InvalidParam.WithMsg("请输入目录名称"), nil)
		return
	}
	if input.DataType == 1 {
		if input.Name == "" {
			SendJsonResponse(c, resp.FAIL.WithMsg("请输入机构名称"), nil)
			return
		}
		if input.OrganizationCode == "" {
			SendJsonResponse(c, resp.FAIL.WithMsg("请输入组织机构代码"), nil)
			return
		}
	}
	orgService := service.Organization{User: header.GetUser(c)}
	if err := orgService.UpdateOrg(cast.ToInt64(c.Param("id")), input); err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// 删除组织或者目录
func DeleteOrg(c *gin.Context) {
	orgService := service.Organization{User: header.GetUser(c)}
	if err := orgService.DeleteOrg(cast.ToInt64(c.Param("id"))); err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// 组织排序
func SortOrg(c *gin.Context) {
	var input []request.OrgSortInput
	if err := c.ShouldBindJSON(&input); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}
	orgService := service.Organization{User: header.GetUser(c)}
	if err := orgService.SortOrg(input); err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// 查询组织树
func GetOrgTree(c *gin.Context) {
	orgService := service.Organization{}
	result, err := orgService.GetOrgTree()
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, result)
}

// 查询组织详情
func OrgDetail(c *gin.Context) {
	var input request.QueryOrgDetailInput
	if err := c.ShouldBind(&input); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}
	if input.OrganizationId == "" {
		SendJsonResponse(c, resp.InvalidParam.WithMsg("组织id必填"), nil)
		return
	}
	//if input.DataType == "" {
	//	SendJsonResponse(c, resp.InvalidParam.WithMsg("DataType必填"), nil)
	//	return
	//}
	if input.Limit == 0 {
		input.Limit = 10
	}
	orgService := service.Organization{}
	result, err := orgService.OrgDetail(input)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, result)
}
