package controller

import (
	"errors"
	vd "github.com/bytedance/go-tagexpr/validator"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
)

// CreateSystemRole 创建角色
func CreateSystemRole(c *gin.Context) {
	params := request.CreateSystemRoleReq{}
	if err := c.ShouldBindJSON(&params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), nil)
		return
	}
	if err := vd.Validate(params); err != nil {
		SendJsonResponse(c, err, "")
		return
	}
	user := header.GetUser(c)
	if user.Id == 0 {
		SendJsonResponse(c, resp.LoginFail.ErrorDetail(errors.New("登录失败")), nil)
		return
	}
	params.CreatedBy = user.Id
	_, err := service.CreateSystemRole(params)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// UpdateSystemRole 编辑角色
func UpdateSystemRole(c *gin.Context) {
	params := request.UpdateSystemRoleReq{}
	if err := c.ShouldBindJSON(&params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), nil)
		return
	}
	if err := vd.Validate(params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), "")
		return
	}
	user := header.GetUser(c)
	if user.Id == 0 {
		SendJsonResponse(c, resp.LoginFail.ErrorDetail(errors.New("登录失败")), nil)
		return
	}
	params.UpdatedBy = user.Id
	// params.UpdatedBy = "1746af3c-059d-4870-b076-6e78c617a142"
	_, err := service.UpdateSystemRole(params)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// SystemRoleState 修改角色状态
func SystemRoleState(c *gin.Context) {
	params := request.SystemRoleStateReq{}
	params.Id = c.Param("id")
	params.State = c.Param("state")
	if err := vd.Validate(params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), "")
		return
	}
	_, err := service.SystemRoleState(params)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// SystemRoleList 系统角色列表
func SystemRoleList(c *gin.Context) {
	params := request.SystemRoleListReq{}
	// 绑定分页数据
	if err := c.ShouldBindQuery(&params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), nil)
		return
	}
	user := header.GetUser(c)
	if user.Id == 0 {
		SendJsonResponse(c, resp.LoginFail.ErrorDetail(errors.New("登录失败")), nil)
		return
	}
	//params.IsAdmin = user.IsAdmin
	// 分页数据初始化 limit page  Offset
	//params.PageInfo = params.PageInfo.InitPage()
	list, count, err := service.SystemRoleList(&params)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonPageResponse(c, err, list, count)
}

// SystemAllotUserList 角色可分配账户列表
func SystemAllotUserList(c *gin.Context) {
	params := request.SystemAllotUserListReq{}
	// 绑定分页数据
	if err := c.ShouldBindQuery(&params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), nil)
		return
	}
	// 分页数据初始化 limit page  Offset
	//params.PageInfo = params.PageInfo.InitPage()
	list, count, err := service.SystemAllotUserList(&params)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonPageResponse(c, err, list, count)
}

// SystemRoleDetail 系统角色详情
func SystemRoleDetail(c *gin.Context) {
	params := request.SystemRoleDetailReq{}
	params.Id = c.Param("id")

	if err := vd.Validate(params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), "")
		return
	}
	result, err := service.SystemRoleDetail(params)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, result)
}

// SystemRoleAllotmentUser 给角色分配账户
func SystemRoleAllotmentUser(c *gin.Context) {
	params := request.SystemRoleAllotmentUserReq{}
	if err := c.ShouldBindJSON(&params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), nil)
		return
	}
	if err := vd.Validate(params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), "")
		return
	}
	err := service.SystemRoleAllotmentUser(&params)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// DeleteSystemRole 删除角色
func DeleteSystemRole(c *gin.Context) {
	params := request.DeleteSystemRoleReq{}
	if err := c.ShouldBindJSON(&params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), nil)
		return
	}
	if err := vd.Validate(params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), "")
		return
	}
	err := service.DeleteSystemRole(params)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}
