package router

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/constant"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
)

// 初始化日志管理路由
func InitLogManagementRouter(e *gin.Engine) {
	logger := e.Group(fmt.Sprintf("%s/log", conf.Options.Prefix))

	{
		systemLog := logger.Group("/system", header.SetContext)
		{
			systemLog.GET("list", controller.GetSystemLoggerList) //系统日志树
			systemLog.GET("log", controller.GetSystemLog)         //系统日志
		}

		//userBehavior := logger.Group("userBehavior", header.SetContext)
		userBehavior := logger.Group("userBehavior")
		{
			//用户行为审计:
			userBehavior.GET("list", controller.LogUserBehaviorList, header.AddLogMiddleware("用户行为审计", "/list", constant.OpTypeIntMap[constant.Find]))                  //用户行为审计列表
			userBehavior.GET("list/export", controller.LogUserBehaviorListExport, header.AddLogMiddleware("用户行为审计", "/export", constant.OpTypeIntMap[constant.Export])) //用户行为审计列表导出
			userBehavior.GET("detail/:id", controller.LogUserBehaviorDetail)                                                                                            //用户行为审计详情
			userBehavior.DELETE("delete", controller.LogUserBehaviorDelete)                                                                                             //用户行为审计删除
		}

		//userAccountAudit := logger.Group("/userAccountAudit", header.SetContext)
		//{
		//	//用户账户审计:
		//	userAccountAudit.GET("list", controller.LogUserAccountAuditList, header.AddLogMiddleware("用户账户审计", "/list", constant.OpTypeIntMap[constant.Find]))              //用户账户审计列表
		//	userAccountAudit.GET("list/export", controller.LogUserAccountAuditExport, header.AddLogMiddleware("用户账户审计", "/export", constant.OpTypeIntMap[constant.Export])) //用户账户审计列表导出
		//
		//}

	}
}
