package router

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
)

// InitMetricConfigRouter 初始化指标配置路由
func InitMetricConfigRouter(e *gin.Engine) {
	mcGroup := e.Group(fmt.Sprintf("%s/metric_config", conf.Options.Prefix))
	{
		mcGroup.POST("", controller.AddMetricConfig)
		mcGroup.PUT("", controller.UpdateMetricConfig)
		mcGroup.DELETE("", controller.DeleteMetricConfig)
		mcGroup.GET("", controller.DetailMetricConfig)
		mcGroup.GET("list", controller.ListMetricConfig)
	}

	acGroup := e.Group(fmt.Sprintf("%s/alert_class", conf.Options.Prefix))
	{
		acGroup.POST("", controller.AddAlertClass)
		acGroup.PUT("move/:direction", controller.MoveAlertClass)
		acGroup.PUT("", controller.UpdateAlertClass)
		acGroup.DELETE("", controller.DeleteAlertClass)
		acGroup.GET("", controller.DetailAlertClass)
		acGroup.GET("list", controller.ListAlertClass)
		acGroup.GET("tree", controller.TreeAlertClass)
	}
}
