package router

import (
	"fmt"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"

	"github.com/gin-gonic/gin"
)

// 初始化组织相关路由
func InitOrganizationRouter(e *gin.Engine) {
	base := e.Group(fmt.Sprintf("%s/org", conf.Options.Prefix), header.SetContext)
	{
		base.POST("/add", controller.AddOrg)      //新增组织or目录
		base.PUT("/:id", controller.UpdateOrg)    //更新组织或目录
		base.DELETE("/:id", controller.DeleteOrg) //删除组织或者目录
		base.PUT("/sort", controller.SortOrg)     //组织排序
		base.GET("/tree", controller.GetOrgTree)  //查询组织树
		base.GET("/detail", controller.OrgDetail) //查询组织详情
	}
}
