package router

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
)

// InitPushRecordRouter 初始化推送记录配置路由
func InitPushRecordRouter(e *gin.Engine) {
	group := e.Group(fmt.Sprintf("%s/push_record", conf.Options.Prefix))
	{
		group.GET("", controller.DetailPushRecord)
		group.GET("list", controller.ListPushRecord)
		group.PUT("", controller.UpdatePushRecord)
	}
}
