package service

import (
	"github.com/jinzhu/copier"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/entity"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/response"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/client"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"
	"xorm.io/xorm"
)

type AlertOverviewSvc struct {
	User entity.SystemUserInfo
}

func (a *AlertOverviewSvc) Add(session *xorm.Session, req request.AddAlertOverview) (classId int, err error) {
	now := jsontime.Now()
	data := entity.AlertOverview{
		CreatedBy: a.User.SystemAccount,
		CreatedAt: now,
		UpdatedBy: a.User.SystemAccount,
		UpdatedAt: now,
	}
	_ = copier.Copy(&data, &req)
	return
}

func (a *AlertOverviewSvc) Update(session *xorm.Session, req request.UpdateAlertOverview) error {
	now := jsontime.Now()
	data := entity.AlertOverview{
		UpdatedBy: a.User.SystemAccount,
		UpdatedAt: now,
	}
	_ = copier.Copy(&data, &req)
	return nil
}

func (a *AlertOverviewSvc) Overview(req request.DetailAlertOverview) (resp response.AlertOverviewItem, err error) {
	now := jsontime.Now()
	resp = response.AlertOverviewItem{
		AlertOverview: []entity.AlertOverview{
			{
				RiskLevel:       4,
				UnresolvedCount: 10,
				TotalCount:      24,
				List: []entity.AlertArray{
					{
						MetricName:      "CPU使用率过高",
						UnresolvedCount: 4,
						TotalCount:      8,
					},
					{
						MetricName:      "内存不足",
						UnresolvedCount: 1,
						TotalCount:      2,
					},
					{
						MetricName:      "磁盘空间不足",
						UnresolvedCount: 3,
						TotalCount:      4,
					},
					{
						MetricName:      "服务中断",
						UnresolvedCount: 1,
						TotalCount:      4,
					},
					{
						MetricName:      "响应时间超时",
						UnresolvedCount: 2,
						TotalCount:      6,
					},
				},
				CreatedBy: "admin",
				CreatedAt: now,
				UpdatedBy: "admin",
				UpdatedAt: now,
			},
			{
				RiskLevel:       3,
				UnresolvedCount: 8,
				TotalCount:      26,
				List: []entity.AlertArray{
					{
						MetricName:      "CPU使用率过高",
						UnresolvedCount: 4,
						TotalCount:      12,
					},
					{
						MetricName:      "内存不足",
						UnresolvedCount: 1,
						TotalCount:      10,
					},
					{
						MetricName:      "磁盘空间不足",
						UnresolvedCount: 3,
						TotalCount:      8,
					},
					{
						MetricName:      "服务中断",
						UnresolvedCount: 1,
						TotalCount:      4,
					},
					{
						MetricName:      "响应时间超时",
						UnresolvedCount: 2,
						TotalCount:      6,
					},
				},
				CreatedBy: "admin",
				CreatedAt: now,
				UpdatedBy: "admin",
				UpdatedAt: now,
			},
			{
				RiskLevel:       2,
				UnresolvedCount: 13,
				TotalCount:      50,
				List: []entity.AlertArray{
					{
						MetricName:      "CPU使用率过高",
						UnresolvedCount: 4,
						TotalCount:      12,
					},
					{
						MetricName:      "内存不足",
						UnresolvedCount: 1,
						TotalCount:      10,
					},
					{
						MetricName:      "磁盘空间不足",
						UnresolvedCount: 3,
						TotalCount:      8,
					},
					{
						MetricName:      "服务中断",
						UnresolvedCount: 1,
						TotalCount:      4,
					},
					{
						MetricName:      "响应时间超时",
						UnresolvedCount: 2,
						TotalCount:      6,
					},
				},
				CreatedBy: "admin",
				CreatedAt: now,
				UpdatedBy: "admin",
				UpdatedAt: now,
			},
			{
				RiskLevel:       1,
				UnresolvedCount: 8,
				TotalCount:      20,
				List: []entity.AlertArray{
					{
						MetricName:      "CPU使用率过高",
						UnresolvedCount: 4,
						TotalCount:      12,
					},
					{
						MetricName:      "内存不足",
						UnresolvedCount: 1,
						TotalCount:      10,
					},
					{
						MetricName:      "磁盘空间不足",
						UnresolvedCount: 3,
						TotalCount:      8,
					},
					{
						MetricName:      "服务中断",
						UnresolvedCount: 1,
						TotalCount:      4,
					},
					{
						MetricName:      "响应时间超时",
						UnresolvedCount: 2,
						TotalCount:      6,
					},
				},
				CreatedBy: "admin",
				CreatedAt: now,
				UpdatedBy: "admin",
				UpdatedAt: now,
			},
		},
		RiskLevelDistribution: []entity.RiskLevelDistribution{
			{
				Name:       "重大风险",
				RiskLevel:  4,
				Percentage: "10%",
			},
			{
				Name:       "较大风险",
				RiskLevel:  3,
				Percentage: "20%",
			},
			{
				Name:       "一般风险",
				RiskLevel:  2,
				Percentage: "30%",
			},
			{
				Name:       "低风险",
				RiskLevel:  1,
				Percentage: "40%",
			},
		},
		AlertStatusDistribution: []entity.AlertStatusDistribution{
			{
				Name:       "未恢复",
				Status:     1,
				Percentage: "30%",
			},
			{
				Name:       "已恢复",
				Status:     2,
				Percentage: "70%",
			},
		},
		AlertClassDistribution: []entity.AlertClassDistribution{
			{
				Name:       "容器集群",
				ClassId:    1,
				Percentage: "30%",
			},
			{
				Name:       "容器节点",
				ClassId:    2,
				Percentage: "20%",
			},
			{
				Name:       "容器组",
				ClassId:    3,
				Percentage: "30%",
			},
			{
				Name:       "网关",
				ClassId:    4,
				Percentage: "20%",
			},
		},
		AlertFrequencyDistribution: []entity.AlertFrequencyDistribution{
			{
				Name:  "0-3时",
				Count: 12,
			},
			{
				Name:  "3-6时",
				Count: 20,
			},
			{
				Name:  "6-9时",
				Count: 11,
			},
			{
				Name:  "9-12时",
				Count: 50,
			},
			{
				Name:  "12-15时",
				Count: 60,
			},
			{
				Name:  "15-18时",
				Count: 30,
			},
			{
				Name:  "18-21时",
				Count: 16,
			},
			{
				Name:  "21-24时",
				Count: 6,
			},
		},
	}

	return
}

func (a *AlertOverviewSvc) List(req request.ListAlertOverview) (resp response.AlertOverviewList, err error) {
	db, err := client.GetDbClient()
	if err != nil {
		return
	}
	session := db.NewSession()
	defer session.Close()
	session.Where("source_from = 1")
	if req.ClassId != 0 {
		session.Where("class_id = ?", req.ClassId)
	}
	if req.ClassName != "" {
		session.Where("class_name LIKE ?", "%"+req.ClassName+"%")
	}
	resp.TotalCount, err = session.Limit(req.GetPageSize(), (req.GetPage()-1)*req.GetPageSize()).
		OrderBy("sort_order").FindAndCount(&resp.List)
	return
}

func (a *AlertOverviewSvc) Delete(ids []int) (err error) {
	db, err := client.GetDbClient()
	if err != nil {
		return
	}
	_, err = db.NewSession().In("class_id", ids).Delete(&entity.AlertOverview{})
	return
}
