package service

import (
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/entity"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/client"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"

	"go.uber.org/zap"
)

type LogSvc struct {
}

// 添加用户行为日志
func (l *LogSvc) AddBehaviorLog(log entity.SystemUserBehavior) error {
	db, err := client.GetDbClient()
	if err != nil {
		conf.Logger.Error("数据库连接失败", zap.Error(err))
		return resp.DbConnectError.ErrorDetail(err)
	}
	_, err = db.Table("system_user_behavior").InsertOne(&log)
	if err != nil {
		conf.Logger.Error("insert error", zap.Error(err))
		return resp.DbInsertError.ErrorDetail(err)
	}
	return nil
}
