package service

import (
	"fmt"
	json "github.com/json-iterator/go"
	"github.com/thoas/go-funk"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/entity"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/response"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/util"
	"net/http"
	"sort"
	"strings"
)

type PrometheusSvc struct {
	User entity.SystemUserInfo
}

func (p *PrometheusSvc) Label(req request.PrometheusLabel) (resp response.PrometheusList, err error) {
	var (
		prometheusLabel  response.PrometheusLabel
		prometheusSeries response.PrometheusSeries
	)

	if req.LabelName != "" {
		url := fmt.Sprintf("%s%s", conf.Options.PrometheusHost, "/api/v1/series")
		bytes, _ := util.Request(url, http.MethodPost,
			[]byte(fmt.Sprintf("match[]=%s", req.LabelName)),
			map[string]string{"Content-Type": util.MediaTypeForm})
		_ = json.Unmarshal(bytes, &prometheusSeries)
		for _, v := range prometheusSeries.Data {
			for k, _ := range v {
				resp.List = append(resp.List, k)
			}
		}
		resp.List = funk.UniqString(resp.List)
		sort.Strings(resp.List)
		resp.TotalCount = int64(len(resp.List))

	} else {
		url := fmt.Sprintf("%s%s", conf.Options.PrometheusHost, "/api/v1/label/__name__/values")
		bytes, _ := util.Request(url, http.MethodGet, nil, nil)
		_ = json.Unmarshal(bytes, &prometheusLabel)
		resp.TotalCount = int64(len(prometheusLabel.Data))
		resp.List = prometheusLabel.Data
	}

	return
}

func (p *PrometheusSvc) LabelValue(req request.PrometheusLabelValue) (resp response.PrometheusList, err error) {
	var (
		prometheusSeries response.PrometheusSeries
		metricLabelMap   = make(map[string][]string, 0)
	)

	url := fmt.Sprintf("%s%s", conf.Options.PrometheusHost, "/api/v1/series")
	bytes, _ := util.Request(url, http.MethodPost,
		[]byte(fmt.Sprintf("match[]=%s", req.MetricName)),
		map[string]string{"Content-Type": util.MediaTypeForm})
	_ = json.Unmarshal(bytes, &prometheusSeries)
	for _, v := range prometheusSeries.Data {
		for key, value := range v {
			metricLabelMap[key] = append(metricLabelMap[key], value)
		}
	}

	if values, ok := metricLabelMap[req.MetricLabel]; ok {
		values = funk.UniqString(values)
		if req.Value != "" {
			values = funk.FilterString(values, func(x string) bool {
				return strings.Contains(x, req.Value)
			})
		}
		resp.List = values
	}
	sort.Strings(resp.List)
	resp.TotalCount = int64(len(resp.List))
	return
}
