package service

import (
	"github.com/jinzhu/copier"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/entity"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/response"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/client"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"
	"xorm.io/xorm"
)

type PushRecordSvc struct {
	User entity.SystemUserInfo
}

func (m *PushRecordSvc) Add(session *xorm.Session, req request.AddPushRecord) (id string, err error) {
	now := jsontime.Now()
	data := entity.PushRecord{
		CreatedBy: m.User.SystemAccount,
		CreatedAt: now,
		UpdatedBy: m.User.SystemAccount,
		UpdatedAt: now,
	}
	_ = copier.Copy(&data, &req)
	_, err = session.Insert(&data)
	if err != nil {
		return
	}
	return
}

func (m *PushRecordSvc) Update(session *xorm.Session, req request.UpdatePushRecord) error {
	now := jsontime.Now()
	data := entity.PushRecord{
		UpdatedBy: m.User.SystemAccount,
		UpdatedAt: now,
	}
	_ = copier.Copy(&data, &req)
	_, err := session.ID(req.Id).Update(&data)
	if err != nil {
		return err
	}
	return nil
}

func (m *PushRecordSvc) GetDataById(req request.DetailPushRecord) (resp response.PushRecordItem, err error) {
	now := jsontime.Time{}
	data := response.PushRecordItem{
		PushRecord: entity.PushRecord{
			Id:            1,
			AlertRulesId:  "83343ef6-4a99-47bd-abb4-bcff52feb2ec",
			RiskLevel:     1,
			SystemAccount: "xiaowang",
			PushTime:      now,
			PushType:      1,
			Status:        1,
			CreatedBy:     "admin",
			CreatedAt:     now,
			UpdatedBy:     "admin",
			UpdatedAt:     now,
		},
		NotifyMethod: []string{"dingtalk", "sms"},
	}
	resp = data
	return
}

func (m *PushRecordSvc) List(req request.ListPushRecord) (resp response.PushRecordList, err error) {
	now := jsontime.Time{}
	data1 := response.PushRecordItem{
		PushRecord: entity.PushRecord{
			Id:            1,
			AlertRulesId:  "83343ef6-4a99-47bd-abb4-bcff52feb2ec",
			RiskLevel:     1,
			SystemAccount: "xiaowang",
			PushTime:      now,
			PushType:      1,
			Status:        1,
			CreatedBy:     "admin",
			CreatedAt:     now,
			UpdatedBy:     "admin",
			UpdatedAt:     now,
		},
		NotifyMethod: []string{"dingtalk", "sms"},
	}
	data2 := response.PushRecordItem{
		PushRecord: entity.PushRecord{
			Id:            1,
			AlertRulesId:  "83343ef6-4a99-47bd-abb4-bcff52feb2ec",
			RiskLevel:     2,
			SystemAccount: "xiaozhang",
			PushTime:      now,
			PushType:      2,
			Status:        2,
			CreatedBy:     "admin",
			CreatedAt:     now,
			UpdatedBy:     "admin",
			UpdatedAt:     now,
		},
		NotifyMethod: []string{"dingtalk", "sms"},
	}
	resp.List = append(resp.List, data1, data2)
	resp.TotalCount = int64(len(resp.List))
	return
}

func (m *PushRecordSvc) Delete(ids []string) (err error) {
	db, err := client.GetDbClient()
	if err != nil {
		return
	}
	_, err = db.NewSession().In("id", ids).Delete(new(entity.PushRecord))
	return
}
