/*
 * @Descripttion:
 * @Author: Zhang YaSong
 * @version:
 * @Date: 2022-10-21 18:21:35
 * @LastEditors: Zhang YaSong
 * @LastEditTime: 2022-10-21 18:36:04
 */
package util

import (
	"net/http"
	"regexp"
	"strings"
	"unsafe"

	"github.com/Luzifer/go-openssl/v4"
	"github.com/google/uuid"
)

var OpenSslManager *openssl.OpenSSL = openssl.New()

func IfDangerCharacter(toMatch string) bool {
	// 正则过滤sql注入的方法
	// 参数 : 要匹配的语句

	//过滤 ‘
	//ORACLE 注解 --  /**/
	//关键字过滤 update ,delete
	str := `(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\b(select|update|and|or|delete|insert|trancate|char|chr|into|substr|ascii|declare|exec|count|master|into|drop|execute)\b)`
	re, err := regexp.Compile(str)
	if err != nil {
		return false
	}
	return re.MatchString(toMatch)
}

func DecryptPwd(pwd string) (str string, err error) {
	passphrase := "swuE9cmCZQwrkYRV"
	dec, err := OpenSslManager.DecryptBytes(passphrase, []byte(pwd), openssl.BytesToKeyMD5)
	return string(dec), err
}

func EncryptPwd(password string) (pwd string, err error) {
	passphrase := "swuE9cmCZQwrkYRV"
	ecs, err := OpenSslManager.EncryptBytes(passphrase, []byte(password), openssl.BytesToKeyMD5)
	return string(ecs), err
}

// GetCookieStr , 获取cookie字符串
func GetCookieStr(req *http.Request) (str string, err error) {
	cookies := req.Cookies()
	for _, v := range cookies {
		str += v.Name + "=" + v.Value + ";"
	}
	return str, nil
}

func GetUUID() string {
	// Creating UUID Version 4
	return uuid.New().String()
}

func SpecialEscape(keyword string) string {
	keyword = strings.Replace(keyword, "\\", "\\\\", -1)
	keyword = strings.Replace(keyword, "$", "\\$", -1)
	keyword = strings.Replace(keyword, "%", "\\%", -1)
	keyword = strings.Replace(keyword, "_", "\\_", -1)
	return keyword
}

func Bytes2Str(b []byte) string {
	return *(*string)(unsafe.Pointer(&b))
}
