package entity

import "time"

type HostManage struct {
	Id         int       `json:"id" xorm:"pk autoincr" `          // id
	HostName   string    `json:"host_name" xorm:"host_name"`      // 主机分组名称
	IsDelete   int       `json:"is_delete"  xorm:"is_delete" `    // 是否删除（0 未删除 1已删除）
	CreateUser string    `json:"create_user" xorm:"create_user" ` // 创建人
	CreateTime time.Time `json:"create_time"  xorm:"create_time"` // 创建时间
	UpdateUser string    `json:"update_user" xorm:"update_user" ` // 修改人
	UpdateTime time.Time `json:"update_time"  xorm:"update_time"` // 修改时间
}

type HostManageList struct {
	Id          int    `json:"id" xorm:"pk autoincr" `             // id
	Ip          string `json:"ip" xorm:"ip"`                       // ip
	Port        string `json:"port" xorm:"port"`                   // 端口
	VoucherType int    `json:"voucher_type" xorm:"voucher_type"`   // 凭证类型（0密码验证 1密钥验证）
	UserName    string `json:"user_name" xorm:"user_name"`         // 用户名
	Password    string `json:"password" xorm:"password"`           // 密码
	HostGroupId int    `json:"host_group_id" xorm:"host_group_id"` // 主机分组id
	HostFileUrl string `json:"host_file_url" xorm:"host_file_url"` // 主机文件url
	IsDelete    int    `json:"is_delete"  xorm:"is_delete" `       // 是否删除（0 未删除 1已删除）
	ConnStatus  int    `json:"conn_status"  xorm:"conn_status" `   // 连接状态（0正常 1异常）
	IpGroup     int    `json:"ip_group"  xorm:"ip_group" `         // ip分组
}

type HostManageListCache struct {
	Id          string `json:"id" xorm:"id" `                    // id
	Ip          string `json:"ip" xorm:"ip"`                     // ip
	Port        string `json:"port" xorm:"port"`                 // 端口
	VoucherType int    `json:"voucher_type" xorm:"voucher_type"` // 凭证类型（0密码验证 密钥验证）
	UserName    string `json:"user_name" xorm:"user_name"`       // 用户名
	Password    string `json:"password" xorm:"password"`         // 密码
	ConnStatus  int    `json:"conn_status"  xorm:"conn_status" ` // 连接状态（0正常 1异常）
	IpGroup     int    `json:"ip_group"  xorm:"ip_group" `       // ip分组
}
