package entity

import (
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"
	"time"
)

type SystemAccessRule struct {
	Id          int32         `json:"id" xorm:"pk autoincr" `            // id
	RuleName    string        `json:"rule_name" xorm:"rule_name"`        // 规则名称
	RuleType    int           `json:"rule_type" xorm:"rule_type"`        // 规则类型
	RuleDetail  string        `json:"rule_detail" xorm:"rule_detail"`    // 规则
	State       int           `json:"state" xorm:"state"`                // 状态0禁用1启用
	CreatedBy   int           `json:"created_by"  `                      // 创建者
	CreatedTime jsontime.Time `json:"created_time" xorm:"created_time" ` // 创建时间
	UpdatedBy   int           `json:"updated_by"  `                      // 更新者
	UpdatedTime jsontime.Time `json:"updated_time" xorm:"updated_time" ` // 更新时间
	RuleId      string        `json:"rule_id"  xorm:"rule_id"`           //规则id
}

func (*SystemAccessRule) TableName() string {
	return "system_access_rule"
}

type SystemRuleUser struct {
	UserId      int       `json:"user_id" xorm:"user_id" `           // 系统账号id
	RuleId      string    `json:"rule_id" xorm:"rule_id"`            // 规则id
	CreatedTime time.Time `json:"created_time" xorm:"created_time" ` // 创建时间
}

func (*SystemRuleUser) TableName() string {
	return "system_rule_user"
}
