package entity

import "time"

// 系统组织表
type SystemOrganization struct {
	Id               int64     `json:"id" xorm:"pk autoincr"`       //id
	OrganizationId   string    `json:"organization_id"`             //组织id
	Name             string    `json:"name"`                        //组织名称or目录名称
	POrganizationId  string    `json:"p_organization_id"`           //父级组织id
	Description      string    `json:"description"`                 //组织介绍
	OrganizationCode string    `json:"organization_code"`           //组织机构代码
	Sort             int64     `json:"sort"`                        //排序
	DataType         int64     `json:"data_type"`                   //数据类型(0目录 1组织)
	CreatedTime      time.Time `json:"created_time" xorm:"created"` //创建时间
	UpdatedTime      time.Time `json:"updated_time" xorm:"updated"` //更新时间
	IsDeleted        int64     `json:"is_deleted"`                  //是否删除0未删除 1已删除
	CreatedBy        int       `json:"created_by"`                  //创建者
	UpdatedBy        int       `json:"updated_by"`                  //更新者
	Level            int64     `json:"level"`                       //组织节点层级
}
