package entity

type SystemPreferenceConfig struct {
	Id int64 `json:"id" xorm:"pk autoincr" vd:"$>0;msg:'请输入配置id'"` //id
	// 授权配置
	SystemVersion    string `json:"system_version"`                          //系统版本号
	SystemUser       string `json:"system_user" vd:"len($)>0;msg:'请输入使用用户'"` //系统User
	License          string `json:"license" vd:"len($)>0;msg:'请输入license'"`  //系统license
	LicenseInformDay int    `json:"license_inform_day"`                      //license剩余有效期提醒
	LicenseDeadDate  string `json:"license_dead_date"`                       //license截至有效期
	// 登录页配置
	Logo          string `json:"logo"`           //logo
	BgImage       string `json:"bg_image"`       //背景图
	BottomTitle   string `json:"bottom_title"`   //底部所有权内容
	Icp           string `json:"icp"`            //ICP备案
	IcpUrl        string `json:"icp_url"`        //ICP备案跳转链接
	Police        string `json:"police"`         //公安网备案
	PoliceUrl     string `json:"police_url"`     //公安网跳转链接
	LegalNotice   string `json:"legal_notice"`   //法律声明
	PrivacyPolicy string `json:"privacy_policy"` //隐私政策
	// 安全配置
	MinPwdLevel      int `json:"min_pwd_level" vd:"$>0;msg:'请选择最低密码强度'"`                                 //最低密码强度1弱2中3强
	ForceUpdateState int `json:"force_update_state"`                                                     //是否强制修改0否1是
	PwdValidity      int `json:"pwd_validity" vd:"$ >= 0;msg:'请输入密码有效期'"`                                //密码有效期
	SessionValidity  int `json:"session_validity" vd:"$ >= 10 && $ <= 30;msg:'会话有效期范围在（10~30分钟），请重新输入'"` //会话有效期
	AccessRuleState  int `json:"access_rule_state" vd:"$== 0 || $==1;msg:'请选择系统访问规则模式'"`                 //访问规则模式0关闭1开启
	// 登录配置
	LoginConfigState int `json:"login_config_state" vd:"$== 0 || $==1;msg:'请选择是否启用登录配置'"` //是否启用登录配置0否1是
	LoginLimitTime   int `json:"login_limit_time"`                                        //登录受限时间
	LoginPwdError    int `json:"login_pwd_error"`                                         //密码错误次数
	LoginLockTime    int `json:"login_lock_time"`                                         //自动锁定时间

}

type LicenseInfo struct {
	License string `json:"license" vd:"len($)>0;msg:'请输入license'"`
}
